/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class StartMethodParameterTraceCommand
extends ProfilingCommand {
    private static final MethodCommandFactory methodCmdFactory = ProfilingFactory.createMethodCommandFactory();
    private static final String KEY_SPEC = "spec";
    private static final String KEY_DESCRIPTION = "description";
    private static final String KEY_METHOD = "method";
    private static final String KEY_INDEX = "index";
    private static final String KEY_INCLUDE_TYPE = "includeType";
    private static final String KEY_MODIFIER = "modifier";
    private static final String KEY_INCLUDE_CPUTIMES = "cpuTime";
    private static final String KEY_INCLUDE_STACKTRACES = "stacktraces";
    private static final String KEY_INCLUDE_TIMESTAMPS = "timestamps";

    public static List<RequestedMethodParameter> createParameterList(Argument[] args) {
        RequestedMethodParameter methodSpec;
        LinkedList<RequestedMethodParameter> methodSpecs = new LinkedList<RequestedMethodParameter>();
        String spec = null;
        String description = "";
        String method = null;
        int index = -1;
        MethodParameterIncludeType includeType = MethodParameterIncludeType.ONLY_DECLARED_CLASS;
        ArrayList<String> modifiers = new ArrayList<String>();
        for (int currentIndex = 0; currentIndex < args.length; ++currentIndex) {
            if (args[currentIndex].getKey().equals(KEY_SPEC)) {
                if (spec != null) {
                    methodSpec = new RequestedMethodParameter(spec, description, method, index, includeType, modifiers);
                    methodSpecs.add(methodSpec);
                    spec = null;
                    description = "";
                    method = null;
                    index = -1;
                    includeType = MethodParameterIncludeType.ONLY_DECLARED_CLASS;
                    modifiers = new ArrayList();
                }
                spec = args[currentIndex].getValue();
                continue;
            }
            if (args[currentIndex].getKey().equals(KEY_DESCRIPTION)) {
                description = args[currentIndex].getValue();
                continue;
            }
            if (args[currentIndex].getKey().equals(KEY_METHOD)) {
                method = args[currentIndex].getValue();
                continue;
            }
            if (args[currentIndex].getKey().equals(KEY_INDEX)) {
                index = Integer.parseInt(args[currentIndex].getValue());
                continue;
            }
            if (args[currentIndex].getKey().equals(KEY_INCLUDE_TYPE)) {
                String typeTag = args[currentIndex].getValue();
                if ("only_in_declared_class".equals(typeTag)) {
                    includeType = MethodParameterIncludeType.ONLY_DECLARED_CLASS;
                    continue;
                }
                if ("not_overwritten".equals(typeTag)) {
                    includeType = MethodParameterIncludeType.NOT_OVERWRITTEN;
                    continue;
                }
                if (!"include_overwritten".equals(typeTag)) continue;
                includeType = MethodParameterIncludeType.INCLUDE_OVERWRITTEN;
                continue;
            }
            if (!args[currentIndex].getKey().equals(KEY_MODIFIER)) continue;
            modifiers.add(args[currentIndex].getValue());
        }
        if (spec != null) {
            methodSpec = new RequestedMethodParameter(spec, description, method, index, includeType, modifiers);
            methodSpecs.add(methodSpec);
        }
        return methodSpecs;
    }

    private static IncludeOptions createIncludeOptions(Argument[] args) {
        boolean includeCPUTimes = true;
        boolean includeStackTraces = true;
        boolean includeTimestamps = true;
        for (Argument arg : args) {
            String booleanString;
            if (arg.getKey().equals(KEY_INCLUDE_CPUTIMES)) {
                booleanString = arg.getValue().trim().toLowerCase();
                includeCPUTimes = !booleanString.equals("false");
                continue;
            }
            if (arg.getKey().equals(KEY_INCLUDE_STACKTRACES)) {
                booleanString = arg.getValue().trim().toLowerCase();
                includeStackTraces = !booleanString.equals("false");
                continue;
            }
            if (!arg.getKey().equals(KEY_INCLUDE_TIMESTAMPS)) continue;
            booleanString = arg.getValue().trim().toLowerCase();
            includeTimestamps = !booleanString.equals("false");
        }
        return new IncludeOptions(includeCPUTimes, includeStackTraces, includeTimestamps);
    }

    public static String toString(List<RequestedMethodParameter> paramList) {
        StringBuilder builder = new StringBuilder();
        boolean start = true;
        for (RequestedMethodParameter requestedMethodParameter : paramList) {
            if (!start) {
                builder.append(";");
            }
            builder.append(requestedMethodParameter.toString());
            start = false;
        }
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "start method parameter trace";
    }

    @Override
    public String getHelpText() {
        return "Starts the method parameter trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage:").append(this.getOpcode()).append(" [<vm>]").append(" <paramSpec>+").append("\n\n<paramSpec>=").append("\n  <spec=specName>").append("\n  [<description=My Spec Description>]").append("\n  <method=com.sap.jvm.Test.methodA(java.lang.String)void>").append("\n  <index=1>").append("\n  [<includeType=only_in_declared_class|not_overwritten|include_overwritten>]").append("\n  [<modifier=hashCode()int>]*\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <spec>\t\tDefines the name of a method parameter specification.\n").append("  <description>\t\tDefines the description of a method parameter specification.\n\t\t\tDefault is no description.\n").append("  <method>\t\tDefines the fully qualified method of a method parameter specification.\n").append("  <index>\t\tDefines the index of the parameter.\n\t\t\t\"0\" represents \"this\", \"1\" is the first method parameter.\n").append("  <includeType>\t\tIf set to 'only_in_declared_class', the method is only traced when the \n\t\t\tthis object is the same class as the one in the method definition. If set \n\t\t\tto 'not_overwritten' the method is traced if the this object is at least \n\t\t\tof thex type in the method definition and not overwritten. If set to \n\t\t\t'include_overwritten' we also include calls to overwritten methods.\n\t\t\tDefault is 'only_in_declared_class'.\n").append("  <modifier>\t\tDefines a modifier for the profiled parameter.\n\t\t\tThis modifier is applied to the parameter value.\n\t\t\tE.g., a modifier 'toString()java.lang.String calls\n\t\t\tthe 'toString' on the parameter value.\n\n\t\t\tThe definition of a modifier is 'methodName()returnType.'\n\t\t\tThe return type must be fully qualified (e.g., java.lang.String).\n\t\t\tThe method name is the simple method name without package info.\n\n\t\t\tThere are also some predefined modifiers.\n\t\t\tThe 'length' modifier can be used with arrays and returns the \n\t\t\tarray length. The 'class'  modifier returns the class of the \n\t\t\tparameter. The modifier '[i]' returns an array value at the \n\t\t\tspecified position 'i'. The modifier '(com.sap.Test)' casts a \n\t\t\tparameter value to the specified type.\n\n\t\t\tIt is possible to provide a chain of modifiers. The first one is\n\t\t\tapplied to the parameter value, the second one is applied to the\n\t\t\treturn value of first modifier and so on. \n\n\t\t\tDefault is no modifier.");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        IncludeOptions includeOptions;
        if (!execEnv.getCapabilities().hasMethodParameterTrace()) {
            return false;
        }
        List<RequestedMethodParameter> methodSpecs = StartMethodParameterTraceCommand.createParameterList(args);
        String errorMessage = execEnv.executeAndWait((Command)methodCmdFactory.createEnableMethodParameterTraceCommand(methodSpecs, (includeOptions = StartMethodParameterTraceCommand.createIncludeOptions(args)).getIncludeTimestamps(), includeOptions.getIncludeCPUTimes(), includeOptions.getIncludeStackTraces(), false));
        return errorMessage == null;
    }

    private static class IncludeOptions {
        private final boolean includeCPUTimes;
        private final boolean includeStackTraces;
        private final boolean includeTimestamps;

        public IncludeOptions(boolean includeCPUTimes, boolean includeStackTraces, boolean includeTimestamps) {
            this.includeCPUTimes = includeCPUTimes;
            this.includeStackTraces = includeStackTraces;
            this.includeTimestamps = includeTimestamps;
        }

        public boolean getIncludeCPUTimes() {
            return this.includeCPUTimes;
        }

        public boolean getIncludeStackTraces() {
            return this.includeStackTraces;
        }

        public boolean getIncludeTimestamps() {
            return this.includeTimestamps;
        }
    }
}

