/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.net.command.EnableNetworkTraceCommand;
import com.sap.jvm.profiling.net.command.NetworkCommandFactory;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ParameterDescriptions;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StartNetworkTraceCommand
extends ProfilingCommand {
    private static final NetworkCommandFactory netCmdFactory = ProfilingFactory.createNetworkCommandFactory();

    @Override
    public String getOpcode() {
        return "start net trace";
    }

    @Override
    public String getHelpText() {
        return "starts the network I/O trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<resolve_all_hosts=true|false>] ").append(" [<vm>] ").append("[<user|session|request|application>=<pattern>]*").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <resolve_all_hosts>\tIf true all reverse DNS lookups are performed for all initial connections.\n").append("\t\t\tDefault is true.\n").append(ParameterDescriptions.getThreadFilterDescription(0));
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean resolveAllHosts = Argument.getBooleanValue(args, "resolve_all_hosts", true);
        ThreadFilter filter = StartNetworkTraceCommand.createThreadFilter(args);
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append(" resolve_all_hosts=").append(resolveAllHosts);
            builder.append(" threadFilter=").append(filter);
            JvmProf.getLogWriter().println(builder.toString());
        }
        NetworkTraceConfiguration config = new NetworkTraceConfiguration();
        config.setThreadFilter(filter);
        config.setResolveAllHosts(resolveAllHosts);
        EnableNetworkTraceCommand cmd = netCmdFactory.createEnableNetworkTraceCommand(config);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

