/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.method.command.RequestedMethodParameter;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ParameterDescriptions;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartMethodParameterTraceCommand;
import java.io.IOException;
import java.util.List;

public final class StartPerformanceHotspotTrace
extends ProfilingCommand {
    private static final MethodCommandFactory methodCmdFactory = ProfilingFactory.createMethodCommandFactory();
    private static final String KEY_IGNORE_SLEEPING_THREADS = "ignoreSleepingThreads";
    private static final boolean VALUE_DEFAULT_IGNORE_SLEEPING_THREADS = true;
    private static final String KEY_SMOOTH_SAMPLING = "smoothSampling";
    private static final boolean VALUE_DEFAULT_SMOOTH_SAMPLING = true;
    private static final int VALUE_DEFAULT_MAX_STACK_TRACE_SIZE = -1;

    @Override
    public String getOpcode() {
        return "start performance hotspot trace";
    }

    @Override
    public String getHelpText() {
        return "Starts the performance hotspot trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]").append(" [<ignoreSleepingThreads=true|false>] ").append(" [<smoothSampling=true|false>] ").append("[<user|session|request|application>=<pattern>]*").append(" [<paramSpec>]*\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\t\tThe VM index when running in a cluster environment.\n").append("  <ignoreSleepingThreads>\tIf set to 'true', sleeping threads are not sampled.\n\t\t\t\tDefault is 'true'.\n").append("  <smoothSampling>\t\tIf set to 'true', we use smooth sampling.\n\t\t\t\tThis leads to better results (more places in which the Java code\n\t\t\t\tcan be interrupted), but more overhead.\n\t\t\t\tDefault is 'true'.\n").append(ParameterDescriptions.getThreadFilterDescription(1) + "\n").append("  <paramSpec>\t\t\tDefines a method parameter which values are profiled in addition.\n\t\t\t\tWithin the analysis, the cpu and sleeping times can be accounted\n\t\t\t\tto the individual method invocations and parameter values.\n\n\t\t\t\tFor details refer to 'start method parameter trace -help'.\n\t\t\t\tDefault is no parameter definitions.");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean ignoreSleepingThreads = Argument.getBooleanValue(args, KEY_IGNORE_SLEEPING_THREADS, true);
        boolean smooth = Argument.getBooleanValue(args, KEY_SMOOTH_SAMPLING, true);
        ThreadFilter filter = StartPerformanceHotspotTrace.createThreadFilter(args);
        List<RequestedMethodParameter> specList = StartMethodParameterTraceCommand.createParameterList(args);
        if (!specList.isEmpty() && !execEnv.getCapabilities().hasMethodParameterTrace()) {
            return false;
        }
        Object cmd = null;
        cmd = specList.isEmpty() ? methodCmdFactory.createEnableTimeBasedSamplingCommand(-1, ignoreSleepingThreads, filter, smooth) : methodCmdFactory.createEnableTimeBasedSamplingMptCommand(-1, ignoreSleepingThreads, filter, smooth, specList, true, true, true, false);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

