/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public final class StartProfilingCommand
extends ProfilingCommand {
    private static ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();
    private static final String KEY_DESTINATION_FILE = "dest";
    private static final String VALUE_DEFAULT_DESTINATION_FILE = "jvmprof.prf";
    private static final String KEY_TIMEOUT = "timeout";

    @Override
    public String getHelpText() {
        return "starts a profiling run inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]").append(" [<dest=myProfiling.prf>]\n").append(" [<timeout=1h>]\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\tThe VM index when running in a cluster environment.\n").append("  <dest>\tThe name of the file where the profiling data gets stored.").append("  <timeout>\tThe timeout of the profiling session being started.");
        return builder.toString();
    }

    @Override
    public String getOpcode() {
        return "start profiling";
    }

    static long convertTimeSpan(String timeSpan) throws NumberFormatException {
        long result = 0L;
        StringTokenizer st = new StringTokenizer(timeSpan, "dhms", true);
        while (st.hasMoreElements()) {
            String numberStr = st.nextToken();
            int number = Integer.parseInt(numberStr);
            if (number < 0) {
                throw new NumberFormatException("Negative time spans are not allowed.");
            }
            String unit = "s";
            if (st.hasMoreTokens()) {
                unit = st.nextToken();
            }
            if (unit.equals("s")) {
                result += (long)number;
                continue;
            }
            if (unit.equals("m")) {
                result += (long)(60 * number);
                continue;
            }
            if (unit.equals("h")) {
                result += (long)(3600 * number);
                continue;
            }
            if (unit.equals("d")) {
                result += (long)(86400 * number);
                continue;
            }
            throw new NumberFormatException("Non-valid unit type '" + unit + "'. Please use one of 'd' [day]/'h' [hour]/'m' [minute]/'s' [second] instead.");
        }
        return result;
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        String errorMessage;
        String destFile = Argument.getStringValue(args, KEY_DESTINATION_FILE, execEnv.getDefaultDestFile());
        if (destFile == null) {
            destFile = VALUE_DEFAULT_DESTINATION_FILE;
        }
        destFile = new File(destFile).getAbsolutePath();
        long timeout = -1L;
        String timeoutStr = Argument.getStringValue(args, KEY_TIMEOUT, null);
        if (timeoutStr != null) {
            try {
                timeout = StartProfilingCommand.convertTimeSpan(timeoutStr);
            }
            catch (NumberFormatException e) {
                System.err.println("Wrong input for timeout: " + e.getMessage());
                return false;
            }
        }
        return (errorMessage = execEnv.executeAndWait((Command)ctrlCmdFactory.createJvmProfStartProfilingCommand(destFile, timeout))) == null;
    }
}

