/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.sync.command.EnableSynchronizationTraceCommand;
import com.sap.jvm.profiling.sync.command.SynchronizationCommandFactory;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ParameterDescriptions;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StartSynchronizationTraceCommand
extends ProfilingCommand {
    private static final SynchronizationCommandFactory syncCmdFactory = ProfilingFactory.createSynchronizationCommandFactory();

    @Override
    public String getOpcode() {
        return "start synchronization trace";
    }

    @Override
    public String getHelpText() {
        return "starts the synchronization trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append("[<user|session|request|application>=<pattern>]*").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append(ParameterDescriptions.getThreadFilterDescription(0));
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        ThreadFilter filter = StartSynchronizationTraceCommand.createThreadFilter(args);
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append(" threadFilter=").append(filter);
            JvmProf.getLogWriter().println(builder.toString());
        }
        SynchronizationTraceConfiguration config = new SynchronizationTraceConfiguration();
        config.setThreadFilter(filter);
        config.setWaitNotifyEnabled(false);
        EnableSynchronizationTraceCommand cmd = syncCmdFactory.createEnableSynchronizationTraceCommand(config);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

