/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.thread.command.ThreadCommandFactory;
import com.sap.jvm.profiling.thread.command.ThreadDumpCommand;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;
import java.util.StringTokenizer;

public final class StartThreadDumpTraceCommand
extends ProfilingCommand {
    private static final ThreadCommandFactory threadCmdFactory = ProfilingFactory.createThreadCommandFactory();
    private static final String KEY_NUMBER_DUMPS = "number";
    private static final int VALUE_DEFAULT_NUMBER_DUMPS = Integer.MAX_VALUE;
    private static final String KEY_PERIOD_DUMPS = "period";
    private static final String VALUE_DEFAULT_PERIOD_DUMPS = "30000";
    private static final String KEY_DELAY = "delay";
    private static final String VALUE_DEFAULT_DELAY = "0";

    @Override
    public String getOpcode() {
        return "start thread dump trace";
    }

    @Override
    public String getHelpText() {
        return "takes thread dumps in the VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append(" [<number=1..n>] ").append(" [<period=timespan>] ").append(" [<delay=timespan>] ").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n").append("  <number>\t\tThe number of thread dumps to be taken. Unlimited by default.\n").append("  <period>\t\tThe time interval between two thread dumps.\n\t\t\tAvailable units: 'h' (hour), 'm' (minute), 's' (second), 'ms' (default: millisecond). \n\t\t\tThe minimum period is 500ms.\n").append("  <delay>\t\tSpecifies the time before the first thread dump is taken.\n\t\t\tSame units available as described for <period>.\n");
        return builder.toString();
    }

    static long convertTimeSpan(String timeSpan) throws NumberFormatException {
        long result = 0L;
        int msIndex = timeSpan.lastIndexOf("ms");
        String timeStr = timeSpan;
        if (msIndex > 0) {
            timeStr = timeSpan.substring(0, msIndex);
        }
        StringTokenizer st = new StringTokenizer(timeStr, "hms", true);
        while (st.hasMoreElements()) {
            String numberStr = st.nextToken();
            int number = Integer.parseInt(numberStr);
            if (number < 0) {
                throw new NumberFormatException("Negative time spans are not allowed.");
            }
            String unit = "ms";
            if (st.hasMoreTokens()) {
                unit = st.nextToken();
            }
            if (unit.equals("s")) {
                result = 1000 * number;
                continue;
            }
            if (unit.equals("m")) {
                result = 60000 * number;
                continue;
            }
            if (unit.equals("h")) {
                result = 3600000 * number;
                continue;
            }
            if (unit.equals("ms")) {
                result = number;
                continue;
            }
            throw new NumberFormatException("Non-valid unit type '" + unit + "'. Please use one of 'h' [hour]/'m' [minute]/'s' [second] /'ms' [millisecond] instead.");
        }
        return result;
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        ThreadDumpConfiguration threadDumpConfig;
        ThreadDumpCommand cmd;
        String errorMessage;
        int number = Argument.getIntValue(args, KEY_NUMBER_DUMPS, Integer.MAX_VALUE);
        long period = -1L;
        long delay = -1L;
        String value = null;
        try {
            value = Argument.getStringValue(args, KEY_PERIOD_DUMPS, VALUE_DEFAULT_PERIOD_DUMPS);
            period = StartThreadDumpTraceCommand.convertTimeSpan(value);
            value = Argument.getStringValue(args, KEY_DELAY, VALUE_DEFAULT_DELAY);
            delay = StartThreadDumpTraceCommand.convertTimeSpan(value);
        }
        catch (NumberFormatException e) {
            System.err.println("Could not convert '" + value + "' to a valid duration");
            return false;
        }
        if (JvmProf.DEBUG) {
            StringBuilder builder = new StringBuilder("JvmProf: Created Options ");
            builder.append("number=").append(number);
            builder.append(" period [ms]=").append(period);
            builder.append(" delay [ms]=").append(delay);
            JvmProf.getLogWriter().println(builder.toString());
        }
        return (errorMessage = execEnv.executeAndWait((Command)(cmd = threadCmdFactory.createEnableThreadDumpsCommand(threadDumpConfig = new ThreadDumpConfiguration(number, period, delay))))) == null;
    }
}

