/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.response.ProfilingTraceInfoResponse;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.ProfilingSessionType;
import com.sap.jvm.profiling.memory.command.DisableAllocationMptTraceCommand;
import com.sap.jvm.profiling.memory.command.MemoryCommandFactory;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationMptTraceResponse;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StopAllocationTraceCommand
extends ProfilingCommand {
    private static final MemoryCommandFactory memCmdFactory = ProfilingFactory.createMemoryCommandFactory();
    private static final ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();

    @Override
    public String getOpcode() {
        return "stop allocation trace";
    }

    @Override
    public String getHelpText() {
        return "stops an allocation trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\tThe VM index when running in a cluster environment.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean mptEnabled = false;
        String errorMessage = execEnv.executeAndWait((Command)ctrlCmdFactory.createProfilingTraceInfoCommand());
        if (errorMessage == null) {
            Response response = execEnv.getLastResponse();
            if (response instanceof ProfilingTraceInfoResponse) {
                Response[] traceInfos;
                ProfilingTraceInfoResponse traceInfo = (ProfilingTraceInfoResponse)response;
                for (Response traceEnable : traceInfos = traceInfo.getStartTraceResponses(ProfilingSessionType.TYPE_PROFILING_CONTROL_JVMPROF)) {
                    if (!(traceEnable instanceof EnableAdaptiveAllocationMptTraceResponse) && !(traceEnable instanceof EnableAllocationMptTraceResponse)) continue;
                    mptEnabled = true;
                    break;
                }
            }
            DisableAllocationMptTraceCommand cmd = mptEnabled ? memCmdFactory.createDisableAllocationMptTraceCommand() : memCmdFactory.createDisableAllocationTraceCommand();
            errorMessage = execEnv.executeAndWait((Command)cmd);
        }
        return errorMessage == null;
    }
}

