/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.response.ProfilingTraceInfoResponse;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.core.command.ProfilingSessionType;
import com.sap.jvm.profiling.method.command.DisableTimeBasedSamplingMptCommand;
import com.sap.jvm.profiling.method.command.MethodCommandFactory;
import com.sap.jvm.profiling.method.response.EnableTimeBasedSamplingMptResponse;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class StopPerformanceHotspotTraceCommand
extends ProfilingCommand {
    private static final MethodCommandFactory methodCmdFactory = ProfilingFactory.createMethodCommandFactory();
    private static final ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();

    @Override
    public String getOpcode() {
        return "stop performance hotspot trace";
    }

    @Override
    public String getHelpText() {
        return "Stops the performance hotspot trace inside a VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>]\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\tThe VM index when running in a cluster environment.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        boolean mptEnabled = false;
        String errorMessage = execEnv.executeAndWait((Command)ctrlCmdFactory.createProfilingTraceInfoCommand());
        if (errorMessage == null) {
            Response response = execEnv.getLastResponse();
            if (response instanceof ProfilingTraceInfoResponse) {
                Response[] traceInfos;
                ProfilingTraceInfoResponse traceInfo = (ProfilingTraceInfoResponse)response;
                for (Response traceEnable : traceInfos = traceInfo.getStartTraceResponses(ProfilingSessionType.TYPE_PROFILING_CONTROL_JVMPROF)) {
                    if (!(traceEnable instanceof EnableTimeBasedSamplingMptResponse)) continue;
                    mptEnabled = true;
                    break;
                }
            }
            DisableTimeBasedSamplingMptCommand cmd = mptEnabled ? methodCmdFactory.createDisableTimeBasedSamplingMptCommand() : methodCmdFactory.createDisableTimeBasedSamplingCommand();
            errorMessage = execEnv.executeAndWait((Command)cmd);
        }
        return errorMessage == null;
    }
}

