/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.command;

import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.thread.command.ThreadCommandFactory;
import com.sap.jvm.profiling.thread.command.ThreadDumpConfiguration;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingCommand;
import java.io.IOException;

public final class ThreadDumpCommand
extends ProfilingCommand {
    private static final ThreadCommandFactory threadCmdFactory = ProfilingFactory.createThreadCommandFactory();

    @Override
    public String getOpcode() {
        return "dump threads";
    }

    @Override
    public String getHelpText() {
        return "takes a thread dump in the VM";
    }

    @Override
    public String getDetailedHelpText() {
        StringBuilder builder = new StringBuilder();
        builder.append("Usage: ").append(this.getOpcode()).append(" [<vm>] ").append("\n");
        builder.append("\nDefinitions:\n").append("  <vm>\t\t\tThe VM index when running in a cluster environment.\n");
        return builder.toString();
    }

    @Override
    protected boolean executeInternal(Argument[] args, ExecutionEnvironment execEnv) throws InvalidVmException, IOException {
        ThreadDumpConfiguration threadDumpConfig = new ThreadDumpConfiguration(1, 0L, 0L);
        com.sap.jvm.profiling.thread.command.ThreadDumpCommand cmd = threadCmdFactory.createEnableThreadDumpsCommand(threadDumpConfig);
        String errorMessage = execEnv.executeAndWait((Command)cmd);
        return errorMessage == null;
    }
}

