/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.controller;

import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.controller.RequestHandler;
import java.io.IOException;

public final class PacketReader
extends Thread {
    private Connection connection;
    private RequestHandler connectionHandler;
    private ProfilingSession session;

    public PacketReader(Connection connection, RequestHandler connectionHandler) throws IOException {
        this.connection = connection;
        this.connectionHandler = connectionHandler;
        try {
            this.session = ProfilingFactory.createSession((Connection)connection);
        }
        catch (IOException ex) {
            ex.printStackTrace(JvmProf.getLogWriter());
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: Closing connection.");
            }
            try {
                connection.close();
            }
            catch (IOException ex2) {
                ex.printStackTrace(JvmProf.getLogWriter());
            }
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: Connection closed.");
            }
            throw ex;
        }
    }

    public ProfilingCapabilities getCapabilities() {
        return this.session.getCapabilities();
    }

    @Override
    public void run() {
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf: Packet Reader started.");
        }
        try {
            ProfilingReader reader = this.session.getReader();
            ProfilingPacket packet = null;
            while ((packet = reader.nextPacket()) != null) {
                if (!(packet instanceof Response)) continue;
                this.connectionHandler.receivedResponse(this.connection, (Response)packet);
            }
            this.connectionHandler.receivedResponse(this.connection, null);
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: Packet Reader stopped.");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace(JvmProf.getLogWriter());
        }
        finally {
            try {
                if (JvmProf.DEBUG) {
                    JvmProf.getLogWriter().println("JvmProf: Closing connection.");
                }
                this.connection.close();
                if (JvmProf.DEBUG) {
                    JvmProf.getLogWriter().println("JvmProf: Connection closed.");
                }
            }
            catch (IOException ex) {
                ex.printStackTrace(JvmProf.getLogWriter());
            }
            if (this.session != null) {
                if (JvmProf.DEBUG) {
                    JvmProf.getLogWriter().println("JvmProf: Closing session.");
                }
                this.session.close();
                if (JvmProf.DEBUG) {
                    JvmProf.getLogWriter().println("JvmProf: Session closed.");
                }
            }
            this.session = null;
        }
    }
}

