/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.controller;

import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.CommandRegistry;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.ProfilingTraceInfoCommand;
import com.sap.jvm.profiling.tools.jvmprof.command.StartProfilingCommand;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public final class Request {
    private int pid;
    private String cmdLine;
    private File cmdFile;
    private String destFile;
    private CommandRegistry cmdRegistry;
    private String errorMessage;
    private static ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();

    public Request(int pid, String cmdLine) {
        this.pid = pid;
        this.cmdLine = cmdLine;
        this.cmdFile = null;
        this.destFile = null;
        this.cmdRegistry = new CommandRegistry();
    }

    public Request(int pid, File cmdFile, String destFile) {
        this.pid = pid;
        this.cmdLine = null;
        this.cmdFile = cmdFile;
        this.destFile = destFile;
        this.cmdRegistry = new CommandRegistry();
    }

    public String getDestinationFile() {
        return this.destFile;
    }

    public int getPid() {
        return this.pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommands(ExecutionEnvironment execEnv) throws IOException {
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf: Start executing commands.");
        }
        ArrayList<String> commands = new ArrayList<String>();
        if (this.cmdLine != null) {
            commands.add(this.cmdLine);
        } else {
            try (BufferedReader commandReader = new BufferedReader(new InputStreamReader(new FileInputStream(this.cmdFile)));){
                String commandLine = null;
                while ((commandLine = commandReader.readLine()) != null) {
                    if ((commandLine = commandLine.trim()).length() <= 0) continue;
                    commands.add(commandLine);
                }
            }
        }
        execEnv.setBatchMode(commands.size() > 1);
        for (String nextCommand : commands) {
            this.handleCommand(execEnv, nextCommand);
            if (!this.hasError()) continue;
            break;
        }
    }

    public boolean hasError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    private void handleCommand(ExecutionEnvironment execEnv, String command) throws IOException {
        String result;
        JvmProfCommand cmd;
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf: Handle command: " + command);
        }
        if ((cmd = this.cmdRegistry.getCommand(command)) == null) {
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: Command does not exist.");
            }
            this.errorMessage = "Command does not exist: " + command;
            throw new IOException(this.errorMessage);
        }
        if (!(cmd instanceof StartProfilingCommand) && !(cmd instanceof ProfilingTraceInfoCommand) && (result = execEnv.executeAndWait((Command)ctrlCmdFactory.createJvmProfForwardCommand())) != null) {
            this.errorMessage = result;
            throw new IOException("Command was not executed successfully:" + this.errorMessage);
        }
        if (!cmd.execute(this.cmdRegistry.getArguments(command, cmd.getOpcode()), execEnv)) {
            this.errorMessage = "Command was not executed successfully: " + execEnv.getErrorMessage();
            throw new IOException(this.errorMessage);
        }
        JvmProf.getLogWriter().println("JvmProf: Command executed successfully.");
    }

    public void exceptionOccurred(Exception e) {
        if (this.errorMessage == null) {
            this.errorMessage = e.getMessage() == null ? e.getClass().getSimpleName() : e.getMessage();
        }
    }
}

