/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.jvmprof.controller;

import com.sap.jvm.monitor.cluster.Cluster;
import com.sap.jvm.monitor.vm.DebugState;
import com.sap.jvm.monitor.vm.InvalidVmException;
import com.sap.jvm.monitor.vm.SuspendPolicy;
import com.sap.jvm.monitor.vm.Vm;
import com.sap.jvm.monitor.vm.VmDebugInfo;
import com.sap.jvm.profiling.CommandHandler;
import com.sap.jvm.profiling.Connection;
import com.sap.jvm.profiling.ProfilingFactory;
import com.sap.jvm.profiling.control.command.ControlCommandFactory;
import com.sap.jvm.profiling.control.command.StopProfilingCommand;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.profiling.tools.jvmprof.ExecutionEnvironment;
import com.sap.jvm.profiling.tools.jvmprof.JvmProf;
import com.sap.jvm.profiling.tools.jvmprof.command.Argument;
import com.sap.jvm.profiling.tools.jvmprof.command.JvmProfCommand;
import com.sap.jvm.profiling.tools.jvmprof.controller.PacketReader;
import com.sap.jvm.profiling.tools.jvmprof.controller.Request;
import com.sap.jvm.util.misc.SocketAdapter;
import java.io.IOException;
import java.util.ArrayList;

public final class RequestHandler {
    private static final ControlCommandFactory ctrlCmdFactory = ProfilingFactory.createControlCommandFactory();
    private static long RESPONSE_TIMEOUT_MS = 300000L;
    private Long waitForResponseId;
    private Response response;
    private volatile boolean stopped = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receivedResponse(Connection connection, Response rsp) {
        Connection connection2 = connection;
        synchronized (connection2) {
            if (this.waitForResponseId == null) {
                return;
            }
            if (rsp == null) {
                this.stopped = true;
            }
            this.response = rsp;
            if (rsp == null || this.waitForResponseId.longValue() == rsp.getId()) {
                connection.notify();
            }
        }
    }

    private Connection attachToProcess(int pid) throws IOException, InvalidVmException {
        Vm vm = Cluster.getVm((int)pid);
        if (vm == null || !vm.isValid()) {
            throw new IOException("Invalid SAP JVM handle.");
        }
        VmDebugInfo debugInfo = vm.getDebugInfo();
        if (debugInfo.getDebugState() == DebugState.STATE_DEBUGGER_ATTACHED) {
            throw new IOException("Other profiler or debugger already attached.");
        }
        vm.startDebug(SuspendPolicy.SUSPEND_NONE);
        int counter = 1000;
        debugInfo = vm.getDebugInfo();
        while (debugInfo.getDebugState() != DebugState.STATE_WAIT_FOR_DEBUGGER || debugInfo.getDebugPort() == -1) {
            debugInfo = vm.getDebugInfo();
            if (debugInfo.getDebugState() == DebugState.STATE_DEBUGGER_ATTACHED) {
                throw new IOException("Other profiler or debugger already attached.");
            }
            if (--counter <= 0) {
                throw new IOException("Debbuger backend did not start up.");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return ProfilingFactory.createDebuggingConnection((String)"localhost", (int)debugInfo.getDebugPort(), (boolean)false, null);
    }

    public void handleRequest(Request request) throws IOException {
        if (JvmProf.DEBUG) {
            JvmProf.getLogWriter().println("JvmProf: handle requests...");
        }
        try (Connection connection = null;){
            if (request.hasError()) {
                return;
            }
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: attach to process " + request.getPid() + ".");
            }
            String errorMsg = null;
            this.stopped = false;
            try {
                SocketAdapter socket = ProfilingFactory.createFileSocket((int)request.getPid(), null);
                connection = ProfilingFactory.createSocketConnection((SocketAdapter)socket, null);
            }
            catch (IOException e) {
                if (JvmProf.DEBUG) {
                    JvmProf.getLogWriter().println("JvmProf: could not connect (profiling) for following reason: " + e.getMessage());
                }
                errorMsg = e.getMessage();
            }
            if (connection == null) {
                try {
                    connection = this.attachToProcess(request.getPid());
                }
                catch (IOException e) {
                    if (JvmProf.DEBUG) {
                        JvmProf.getLogWriter().println("JvmProf: could not connect (debugging) for following reason: " + e.getMessage());
                    }
                    errorMsg = e.getMessage();
                }
                catch (InvalidVmException e) {
                    if (JvmProf.DEBUG) {
                        JvmProf.getLogWriter().println("JvmProf: could not connect (debugging) for following reason: " + e.getMessage());
                    }
                    errorMsg = e.getMessage();
                }
            }
            if (connection == null) {
                assert (errorMsg != null);
                throw new IOException("Cannot attach to process " + request.getPid() + ": " + errorMsg);
            }
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: attached to process " + request.getPid());
                JvmProf.getLogWriter().flush();
            }
            PacketReader readerThread = new PacketReader(connection, this);
            assert (readerThread.getCapabilities().getSystemInfo() != null);
            if (!readerThread.getCapabilities().getSystemInfo().supportsJvmProfControl()) {
                JvmProf.getLogWriter().println("JvmProf: Missing JvmProf support.");
                throw new IOException("Cannot attach to process " + request.getPid() + ". jvmprof needs the VM started with -XX:+Profiling20.");
            }
            readerThread.start();
            ExecutionEnvironmentImpl execEnv = new ExecutionEnvironmentImpl(connection, readerThread.getCapabilities(), request.getDestinationFile(), request.getPid());
            request.executeCommands(execEnv);
            request.setErrorMessage(execEnv.getErrorMessage());
            connection.close();
            try {
                readerThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (JvmProf.DEBUG) {
                JvmProf.getLogWriter().println("JvmProf: Reader thread stopped.");
            }
        }
    }

    static {
        String timeoutProp = System.getProperty("com.sap.jvm.profiling.tools.jvmprof.controller.RequestHandler.RequestTimeout");
        if (timeoutProp != null) {
            try {
                RESPONSE_TIMEOUT_MS = 1000L * Long.parseLong(timeoutProp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class ExecutionEnvironmentImpl
    implements ExecutionEnvironment {
        private Connection connection;
        private CommandHandler cmdHandler;
        private ProfilingCapabilities capabilities;
        private String errorMessage;
        private String defaultDestFile;
        private int pid;
        private volatile boolean isCancelled;
        private boolean batchMode;

        public ExecutionEnvironmentImpl(Connection connection, ProfilingCapabilities capabilities, String destFile, int pid) {
            this.connection = connection;
            this.capabilities = capabilities;
            this.cmdHandler = ProfilingFactory.createCommandHandler((Connection)connection);
            this.errorMessage = null;
            this.defaultDestFile = destFile;
            this.pid = pid;
            this.isCancelled = false;
            this.batchMode = false;
        }

        public ArrayList<JvmProfCommand> getCommands() {
            return null;
        }

        @Override
        public ProfilingCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Override
        public Connection getConnection() {
            return this.connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String executeAndWait(Command cmd) throws IOException {
            Connection connection = this.connection;
            synchronized (connection) {
                RequestHandler.this.response = null;
                RequestHandler.this.stopped = false;
                this.errorMessage = null;
                RequestHandler.this.waitForResponseId = cmd.getId();
                this.cmdHandler.sendCommand(cmd);
                if (!(cmd instanceof StopProfilingCommand)) {
                    this.cmdHandler.sendCommand((Command)ctrlCmdFactory.createFlushCommand());
                }
                long currentMs = System.currentTimeMillis();
                while (RequestHandler.this.response == null && !RequestHandler.this.stopped) {
                    try {
                        this.connection.wait(RESPONSE_TIMEOUT_MS);
                        long waitMs = System.currentTimeMillis();
                        if (waitMs - currentMs < RESPONSE_TIMEOUT_MS) continue;
                        this.errorMessage = "Got request timeout";
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                assert (RequestHandler.this.response == null || RequestHandler.this.stopped || RequestHandler.this.response.getId() == cmd.getId());
                if (this.errorMessage == null && RequestHandler.this.response != null) {
                    this.errorMessage = RequestHandler.this.response.getErrorMessage();
                }
            }
            return this.errorMessage;
        }

        @Override
        public Response getLastResponse() {
            return RequestHandler.this.response;
        }

        @Override
        public String[] getHistory() {
            return null;
        }

        @Override
        public Vm getVm(Argument[] args) {
            return null;
        }

        @Override
        public Vm getVm(int index) {
            return null;
        }

        @Override
        public Vm[] getVms() {
            return null;
        }

        @Override
        public String getErrorMessage() {
            return this.errorMessage;
        }

        @Override
        public String getDefaultDestFile() {
            return this.defaultDestFile;
        }

        @Override
        public int getPid() {
            return this.pid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() throws IOException {
            Connection connection = this.connection;
            synchronized (connection) {
                this.isCancelled = true;
                this.connection.close();
            }
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }

        @Override
        public void setBatchMode(boolean batchMode) {
            this.batchMode = batchMode;
        }

        @Override
        public boolean isBatchMode() {
            return this.batchMode;
        }
    }
}

