/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.JvmProfReportShell;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandRegistry;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.SessionRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class JvmProfReport {
    private static final CommandLineParser.Option helpOption = new CommandLineParser.OptionalSwitch("h", "help");
    private static final CommandLineParser.Option questionOption = new CommandLineParser.OptionalSwitch("?", "?");
    private static final CommandLineParser.Option commandOption = new CommandLineParser.OptionalEqualsOption("c", "command");
    private static final CommandLineParser.Option fileOption = new CommandLineParser.OptionalEqualsOption("f", "file");
    private static final CommandLineParser.Option[] options = new CommandLineParser.Option[]{helpOption, questionOption, commandOption, fileOption};

    private static void printUsage() {
        System.out.println("Executes user-defined reports on a profiling file.");
        System.out.println();
        System.out.println("Syntax: jvmprof-report [<options> ...] <profiling-file>");
        System.out.println();
        System.out.println("The following options are supported: ");
        System.out.println("-?, --?");
        System.out.println("            Print usage information (this message).");
        System.out.println("-c, --command=<command(s)>");
        System.out.println("            Executes the given commands as user-defined report.");
        System.out.println("            Commands are separated by a ';' character.");
        System.out.println("-f, --file=<command-file>");
        System.out.println("            Executes the commands specified in the given command file.");
        System.out.println("            Each command is expected to be on a separate line.");
        System.out.println("            Lines starting with a '#' character are ignored.");
        System.out.println("-h, --help");
        System.out.println("            Print usage information (this message).");
    }

    private static void checkArguments(CommandLineParser parser) throws JvmProfReportException {
        String[] remainingArgs = parser.getRemainingArguments();
        if (remainingArgs.length > 1) {
            throw new JvmProfReportException("Too many arguments: " + Arrays.asList(remainingArgs));
        }
        assert (remainingArgs.length == 1);
        File file = new File(remainingArgs[0]);
        if (file.isDirectory()) {
            throw new JvmProfReportException("Specified file is a directory: " + remainingArgs[0]);
        }
        if (!file.exists()) {
            throw new JvmProfReportException("File not found: " + remainingArgs[0]);
        }
        if (parser.isOptionSet(commandOption) && parser.isOptionSet(fileOption)) {
            throw new JvmProfReportException("Conflicting options: --command=<command(s)> and --file=<command-file>");
        }
    }

    private static void runInteractively(CommandLineParser parser, ReportExecutionContext context) throws JvmProfReportException {
        new JvmProfReportShell(parser, context).handleCommands();
    }

    private static void runNonInteractive(CommandLineParser parser, ReportExecutionContext context) throws JvmProfReportException {
        String[] commands;
        assert (parser.isOptionSet(commandOption) || parser.isOptionSet(fileOption));
        if (parser.isOptionSet(commandOption)) {
            commands = JvmProfReport.parseCommandOption(parser);
        } else {
            assert (parser.isOptionSet(fileOption));
            commands = JvmProfReport.parseCommandFile(parser);
        }
        if (commands.length == 0) {
            throw new JvmProfReportException("No command(s) specified");
        }
        ReportCommandRegistry registry = new ReportCommandRegistry();
        ReportExecutionContext executionContext = context;
        int i = 1;
        for (String c : commands) {
            if ("".equals(c = c.trim())) continue;
            ReportCommand command = registry.getCommand(c);
            try {
                executionContext = command.execute(executionContext);
            }
            catch (JvmProfReportException e) {
                throw new JvmProfReportException(i + ". command failed (" + c + "): " + e.getMessage());
            }
            ++i;
        }
    }

    private static String[] parseCommandOption(CommandLineParser parser) throws JvmProfReportException {
        String commandValue = parser.getValue(commandOption, "");
        if ("".equals(commandValue.trim())) {
            throw new JvmProfReportException("No command specified for --command=<command(s)>");
        }
        return commandValue.split(";");
    }

    private static String[] parseCommandFile(CommandLineParser parser) throws JvmProfReportException {
        String file = parser.getValue(fileOption, "");
        ArrayList<String> commandList = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || "".equals(line = line.trim())) continue;
                commandList.add(line);
            }
        }
        catch (IOException e) {
            throw new JvmProfReportException("Failed reading command file: " + file);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new JvmProfReportException("Failed closing command file: " + file);
            }
        }
        return commandList.toArray(new String[commandList.size()]);
    }

    public static void main(String[] args) {
        boolean failure = JvmProfReport.run(args);
        if (failure) {
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(String[] args) {
        CommandLineParser parser = new CommandLineParser(args, options, false);
        String[] remainingArgs = parser.getRemainingArguments();
        if (parser.isOptionSet(helpOption) || parser.isOptionSet(questionOption) || remainingArgs.length == 0) {
            JvmProfReport.printUsage();
            return false;
        }
        JvmProfReport.checkArguments(parser);
        assert (remainingArgs.length == 1);
        boolean isInteractive = !parser.isOptionSet(commandOption) && !parser.isOptionSet(fileOption);
        SessionRegistry registry = new SessionRegistry();
        try {
            ReportExecutionContext context = ReportExecutionContext.create(registry, remainingArgs[0], isInteractive);
            if (isInteractive) {
                JvmProfReport.runInteractively(parser, context);
            } else {
                JvmProfReport.runNonInteractive(parser, context);
            }
            boolean bl = false;
            registry.cleanUp();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                registry.cleanUp();
                throw throwable;
            }
            catch (CommandLineParser.UnknownOptionException e) {
                System.err.println("Unknown option '" + e.getMessage() + "'.");
            }
            catch (CommandLineParser.MissingOptionException e) {
                System.err.println("Mandatory option '" + e.getMessage() + "' missing.");
            }
            catch (CommandLineParser.MissingOptionValueException e) {
                System.err.println("Value of option '" + e.getMessage() + "' missing.");
            }
            catch (CommandLineParser.IllegalOptionFormatException e) {
                System.err.println("Format of option '" + e.getMessage() + "' illegal.");
            }
            catch (JvmProfReportException e) {
                System.err.println(e.getMessage());
            }
        }
        JvmProfReport.printUsage();
        return true;
    }
}

