/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report;

import com.sap.jvm.internal.util.cmdline.CommandLineParser;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportCommandRegistry;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.tools.console.Completor;
import com.sap.jvm.tools.console.ConsoleReader;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public class JvmProfReportShell {
    private final ConsoleReader input = new ConsoleReader(new CommandCompletor());
    private final ReportCommandRegistry registry = new ReportCommandRegistry();
    private ReportExecutionContext context;

    public JvmProfReportShell(CommandLineParser parser, ReportExecutionContext context) {
        this.context = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleCommands() throws JvmProfReportException {
        try {
            String line;
            block4: while ((line = this.input.readLine(false)) != null) {
                if ("".equals(line = line.trim())) continue;
                if (this.input.isHistoryCommand(line)) {
                    if ((line = this.input.getHistoryCommand(line)) == null) continue;
                    System.out.println(line);
                }
                if ("history".equals(line)) {
                    String[] stringArray = this.input.getHistory();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) continue block4;
                        String history = stringArray[n2];
                        if (!history.equals("history")) {
                            System.out.println(history);
                        }
                        ++n2;
                    }
                }
                if ("exit".equals(line)) return;
                if ("quit".equals(line)) {
                    return;
                }
                try {
                    ReportCommand command = this.registry.getCommand(line);
                    this.context = command.execute(this.context);
                }
                catch (JvmProfReportException e) {
                    this.input.printString(e.getMessage());
                    this.input.printNewline();
                }
            }
            return;
        }
        catch (IOException e) {
            throw new JvmProfReportException("Error while reading input: " + e.getMessage());
        }
    }

    private final class CommandCompletor
    implements Completor {
        private CommandCompletor() {
        }

        @Override
        public void complete(String buffer, List<String> candidates) {
            for (ReportCommandFactory factory : JvmProfReportShell.this.registry.getCommandFactories()) {
                factory.getCommandProposals(buffer, candidates, JvmProfReportShell.this.context);
            }
            Collections.sort(candidates);
        }
    }
}

