/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report;

import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.command.AreaVisibilityCommandFactory;
import com.sap.jvm.profiling.tools.report.command.CacheCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ColumnVisibilityCommandFactory;
import com.sap.jvm.profiling.tools.report.command.CompareCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ComponentCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ExitCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ExpandCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ExportCommandFactory;
import com.sap.jvm.profiling.tools.report.command.FilterCommandFactory;
import com.sap.jvm.profiling.tools.report.command.GraphTypeCommandFactory;
import com.sap.jvm.profiling.tools.report.command.HelpCommandFactory;
import com.sap.jvm.profiling.tools.report.command.InfoCommandFactory;
import com.sap.jvm.profiling.tools.report.command.InliningCommandFactory;
import com.sap.jvm.profiling.tools.report.command.OpenSnapshotCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ReadCommandFactory;
import com.sap.jvm.profiling.tools.report.command.SaveCommandFactory;
import com.sap.jvm.profiling.tools.report.command.SelectCommandFactory;
import com.sap.jvm.profiling.tools.report.command.SetCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommandFactory;
import com.sap.jvm.profiling.tools.report.command.SortCommandFactory;

public final class ReportCommandRegistry {
    private final ReportCommandFactory[] factories = new ReportCommandFactory[]{new ReadCommandFactory(), new OpenSnapshotCommandFactory(), new ShowStatisticCommandFactory(), new SelectCommandFactory(), new SortCommandFactory(), new ExpandCommandFactory(), new FilterCommandFactory(), new InliningCommandFactory(), new ColumnVisibilityCommandFactory(), new CacheCommandFactory(), new CompareCommandFactory(), new ExportCommandFactory(), new SaveCommandFactory(), new ComponentCommandFactory(), new InfoCommandFactory(), new HelpCommandFactory(this), new ExitCommandFactory(), new GraphTypeCommandFactory(), new AreaVisibilityCommandFactory(), new SetCommandFactory()};

    public ReportCommand getCommand(String command) throws JvmProfReportException {
        for (ReportCommandFactory rcf : this.factories) {
            ReportCommand result = rcf.create(command);
            if (result == null) continue;
            return result;
        }
        boolean gotHelp = false;
        for (ReportCommandFactory rcf : this.factories) {
            gotHelp = rcf.printUsage(command) || gotHelp;
        }
        if (gotHelp) {
            throw new JvmProfReportException("");
        }
        throw new JvmProfReportException("Unknown command: " + command);
    }

    public ReportCommandFactory[] getCommandFactories() {
        return (ReportCommandFactory[])this.factories.clone();
    }
}

