/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.SessionRegistry;
import com.sap.jvm.profiling.ui.graph.renderer.Font;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ReportExecutionContext {
    private final FileController controller;
    private final Object context;
    private final Map<String, Object> savedContexts;
    private final SessionRegistry registry;
    private final boolean isInteractive;
    private final Map<String, String> components;
    private char decimalPoint;
    private String comma;
    private boolean overwrite;
    private boolean includeColumnTitles = true;
    private Font font;

    private ReportExecutionContext(FileController controller, Object context, Map<String, Object> savedContexts, SessionRegistry registry, boolean isInteractive, Map<String, String> components) {
        this.controller = controller;
        this.context = context;
        this.savedContexts = new HashMap<String, Object>(savedContexts);
        this.registry = registry;
        this.isInteractive = isInteractive;
        this.components = new LinkedHashMap<String, String>(components);
        this.decimalPoint = (char)46;
        this.comma = ",";
    }

    private ReportExecutionContext copyContext(FileController inheritedController, Object inheritedContext) {
        ReportExecutionContext newContext = new ReportExecutionContext(inheritedController, inheritedContext, this.savedContexts, this.registry, this.isInteractive, this.components);
        newContext.comma = this.comma;
        newContext.decimalPoint = this.decimalPoint;
        newContext.overwrite = this.overwrite;
        newContext.font = this.font;
        return newContext;
    }

    public Object getController() {
        if (this.context != null) {
            return this.context;
        }
        return this.controller;
    }

    public FileController getFileController() {
        return this.controller;
    }

    public Object getSavedController(String name) {
        return this.savedContexts.get(name);
    }

    public void saveController(String name, Object savedController) {
        this.savedContexts.put(name, savedController);
    }

    public ReportExecutionContext openFile(String file) throws JvmProfReportException {
        FileController fileController = this.registry.create(file, this.isInteractive);
        return this.copyContext(fileController, null);
    }

    public ReportExecutionContext changeContext(Object newContext) {
        return this.copyContext(this.controller, newContext);
    }

    public boolean isInteractive() {
        return this.isInteractive;
    }

    public void defineComponent(String name, String pattern) {
        this.components.put(name, pattern);
    }

    public void deleteComponent(String name) {
        this.components.remove(name);
    }

    public MethodFilter[] getComponents() throws FilterParseException {
        ArrayList<MethodFilter> result = new ArrayList<MethodFilter>();
        ProfilingSession session = this.controller.getProfilingSession();
        for (Map.Entry<String, String> entry : this.components.entrySet()) {
            result.add(new MethodFilter(session, entry.getKey(), entry.getValue()));
        }
        return result.toArray(new MethodFilter[result.size()]);
    }

    public int getComponentCount() {
        return this.components.size();
    }

    public static ReportExecutionContext create(SessionRegistry registry, String file, boolean isInteractive) throws JvmProfReportException {
        FileController fileController = registry.create(file, isInteractive);
        return new ReportExecutionContext(fileController, null, Collections.emptyMap(), registry, isInteractive, Collections.emptyMap());
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setDecimalPoint(char decimalPoint) {
        this.decimalPoint = decimalPoint;
    }

    public String getComma() {
        return this.comma;
    }

    public void setComma(String comma) {
        this.comma = comma;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public boolean includeColumnTitles() {
        return this.includeColumnTitles;
    }

    public void setIncludeColumnTitles(boolean includeColumnTitles) {
        this.includeColumnTitles = includeColumnTitles;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }
}

