/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report;

import com.sap.jvm.profiling.controller.ControllerFactory;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.impl.FileControllerImpl;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class SessionRegistry {
    private final Set<File> directories = new HashSet<File>();
    private final Set<FileController> controllers = new HashSet<FileController>();

    public FileController create(String file, boolean isInteractive) throws JvmProfReportException {
        File dir = this.createTempDir();
        this.directories.add(dir);
        if (isInteractive) {
            System.out.print("Reading file '" + file + "'... ");
        }
        try {
            FileControllerImpl fc = ControllerFactory.create(file, dir.getAbsolutePath(), dir);
            this.controllers.add(fc);
            ProgressReporter reporter = new ProgressReporter();
            fc.process(reporter);
            reporter.finish();
            if (isInteractive) {
                System.out.println("finished.");
            }
            return fc;
        }
        catch (IOException e) {
            if (isInteractive) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("I/O error while processing file '" + file + "': " + e.getMessage());
        }
    }

    public void cleanUp() {
        for (FileController fc : this.controllers) {
            fc.close(true);
        }
        this.controllers.clear();
        for (File dir : this.directories) {
            if (this.deleteFile(dir)) continue;
            System.err.println("Could not delete working directory: " + dir);
        }
        this.directories.clear();
    }

    private File createTempDir() throws JvmProfReportException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        String name = "jvmprof-report-" + System.currentTimeMillis() + "-";
        for (int i = 0; i < 1000; ++i) {
            File result = new File(tmpDir, name + i);
            if (!result.mkdir()) continue;
            return result;
        }
        throw new JvmProfReportException("Could not create temporary directory in " + tmpDir);
    }

    private boolean deleteFile(File file) {
        File[] files;
        boolean result = true;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                result = this.deleteFile(f) && result;
            }
        }
        if (!file.delete()) {
            if (result) {
                System.out.println("Could not delete file '" + file + "'");
            }
            result = false;
        }
        return result;
    }
}

