/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import java.util.ArrayList;

public final class AddAllAreasCommand
implements ReportCommand {
    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        ArrayList<String> nonEmptyAreas;
        TypedTimeSeriesModel model;
        Object input = context.getController();
        if (input instanceof TimeSeriesResourceController) {
            TimeSeriesResourceController controller = (TimeSeriesResourceController)input;
            model = (TypedTimeSeriesModel)controller.getModel();
            String[] allTags = model.getTags();
            nonEmptyAreas = new ArrayList<String>();
            for (String tag : allTags) {
                if (model.isEmpty(tag)) continue;
                nonEmptyAreas.add(tag);
            }
        } else {
            throw new JvmProfReportException("Unsupported controller type for adding areas: " + input.getClass().getName());
        }
        model.setVisibility(nonEmptyAreas.toArray(new String[nonEmptyAreas.size()]));
        if (context.isInteractive()) {
            System.out.println("All areas added.");
        }
        return context;
    }
}

