/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.AreaVisibilityCommandFactory;

public final class AddAreaCommand
implements ReportCommand {
    private final String area;

    public AddAreaCommand(String area) {
        this.area = area;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        String[] alreadyVisible;
        Object input = context.getController();
        if (!(input instanceof TimeSeriesResourceController)) {
            throw new JvmProfReportException("Unsupported controller type for adding areas: " + input.getClass().getName());
        }
        TimeSeriesResourceController controller = (TimeSeriesResourceController)input;
        TypedTimeSeriesModel model = (TypedTimeSeriesModel)controller.getModel();
        for (String v : alreadyVisible = model.getVisibilitySet()) {
            if (!v.equals(this.area) || !context.isInteractive()) continue;
            System.out.println("Areas '" + this.area + "' was already visible.");
            return context;
        }
        boolean known = false;
        for (String v : model.getTags()) {
            if (!v.equals(this.area)) continue;
            known = true;
            break;
        }
        if (!known) {
            System.err.println("Unknown column: " + this.area);
            AreaVisibilityCommandFactory.printPossibleAreas(model);
            throw new JvmProfReportException("");
        }
        if (model.isEmpty(this.area)) {
            if (context.isInteractive()) {
                System.out.println("There is no data for area '" + this.area + "'.");
            }
        } else {
            String[] newTags = new String[alreadyVisible.length + 1];
            System.arraycopy(alreadyVisible, 0, newTags, 1, alreadyVisible.length);
            newTags[0] = this.area;
            model.setVisibility(newTags);
            if (context.isInteractive()) {
                System.out.println("Area '" + this.area + "' added.");
            }
        }
        return context;
    }
}

