/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.AddAllAreasCommand;
import com.sap.jvm.profiling.tools.report.command.AddAreaCommand;
import com.sap.jvm.profiling.tools.report.command.RemoveAreaCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class AreaVisibilityCommandFactory
implements ReportCommandFactory {
    private static final String ADD_AREAS_PREFIX = "add area ";
    private static final String ADD_ALL_AREAS_PREFIX = "add all areas";
    private static final String REMOVE_AREA_PREFIX = "remove area ";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.equals(ADD_ALL_AREAS_PREFIX)) {
            return new AddAllAreasCommand();
        }
        if (c.startsWith(ADD_AREAS_PREFIX)) {
            String content = c.substring(ADD_AREAS_PREFIX.length());
            return new AddAreaCommand(content);
        }
        if (c.startsWith(REMOVE_AREA_PREFIX)) {
            String content = c.substring(REMOVE_AREA_PREFIX.length());
            return new RemoveAreaCommand(content);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() <= ADD_AREAS_PREFIX.length() && ADD_AREAS_PREFIX.startsWith(prefix) || prefix.length() <= ADD_ALL_AREAS_PREFIX.length() && ADD_ALL_AREAS_PREFIX.startsWith(prefix) || prefix.length() <= REMOVE_AREA_PREFIX.length() && REMOVE_AREA_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Adds/removes areas from the time series output");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  add area <area>");
        System.out.println("  add all areas");
        System.out.println("  remove area <area>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <area>                 The name of the area to add or remove.");
        System.out.println("                         The range of valid names is specific for each time series.");
        System.out.println("                         (All possible areas names are shown in case the name is unknown.)");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        String area;
        Object context = executionContext.getController();
        if (!(context instanceof TimeSeriesResourceController)) {
            return;
        }
        if (ADD_ALL_AREAS_PREFIX.startsWith(commandPrefix)) {
            commands.add(ADD_ALL_AREAS_PREFIX);
        }
        TimeSeriesResourceController controller = (TimeSeriesResourceController)context;
        TypedTimeSeriesModel model = (TypedTimeSeriesModel)controller.getModel();
        if (ADD_AREAS_PREFIX.startsWith(commandPrefix) && ADD_AREAS_PREFIX.length() > commandPrefix.length()) {
            commands.add(ADD_AREAS_PREFIX);
        }
        if (commandPrefix.startsWith(ADD_AREAS_PREFIX)) {
            area = commandPrefix.substring(ADD_AREAS_PREFIX.length()).trim();
            HashSet<String> sets = new HashSet<String>(Arrays.asList(model.getTags()));
            sets.removeAll(Arrays.asList(model.getVisibilitySet()));
            for (String set : sets) {
                if (!set.startsWith(area) || model.isEmpty(set)) continue;
                commands.add(ADD_AREAS_PREFIX + set);
            }
        }
        if (REMOVE_AREA_PREFIX.startsWith(commandPrefix) && REMOVE_AREA_PREFIX.length() > commandPrefix.length()) {
            commands.add(REMOVE_AREA_PREFIX);
        }
        if (commandPrefix.startsWith(REMOVE_AREA_PREFIX)) {
            area = commandPrefix.substring(REMOVE_AREA_PREFIX.length()).trim();
            for (String set : model.getVisibilitySet()) {
                if (!set.startsWith(area)) continue;
                commands.add(REMOVE_AREA_PREFIX + set);
            }
        }
    }

    public static void printPossibleAreas(TypedTimeSeriesModel model) {
        System.err.println("Possible areas are: ");
        String[] tags = model.getTags();
        Arrays.sort(tags, String.CASE_INSENSITIVE_ORDER);
        for (String v : tags) {
            if (model.isEmpty(v)) continue;
            System.err.println(v);
        }
    }
}

