/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.CacheCommand;
import java.util.List;

public final class CacheCommandFactory
implements ReportCommandFactory {
    public static final String DEFAULT_CACHE_NAME = "OLD";
    private static final String CACHE_PREFIX = "cache";
    private static final String CACHE_WITH_NAME_PREFIX = "cache as ";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.equals(CACHE_PREFIX)) {
            return new CacheCommand(DEFAULT_CACHE_NAME);
        }
        if (c.startsWith(CACHE_WITH_NAME_PREFIX)) {
            String name = c.substring(CACHE_WITH_NAME_PREFIX.length()).trim();
            return new CacheCommand(name);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !CACHE_PREFIX.startsWith(prefix = commandPrefix.trim())) {
            return false;
        }
        System.out.println("Cache the current statistic for comparisons");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  cache");
        System.out.println("  cache as <name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The optional name of the current statistic.");
        System.out.println("                         The default name is 'OLD'.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController)) {
            return;
        }
        if (CACHE_PREFIX.startsWith(commandPrefix)) {
            commands.add(CACHE_PREFIX);
        }
        if (commandPrefix.length() > CACHE_PREFIX.length() && CACHE_WITH_NAME_PREFIX.startsWith(commandPrefix)) {
            commands.add(CACHE_WITH_NAME_PREFIX);
        }
    }
}

