/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ColumnResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedColumnSpec;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.VisibilitySet;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.AddAllColumnsCommand;
import com.sap.jvm.profiling.tools.report.command.AddColumnCommand;
import com.sap.jvm.profiling.tools.report.command.RemoveColumnCommand;
import com.sap.jvm.profiling.tools.report.command.RemoveNonDefaultColumnsCommand;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public final class ColumnVisibilityCommandFactory
implements ReportCommandFactory {
    private static final String ADD_COLUMN_PREFIX = "add column ";
    private static final String ADD_ALL_COLUMNS_PREFIX = "add all columns";
    private static final String REMOVE_COLUMN_PREFIX = "remove column ";
    private static final String REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX = "remove all non-default columns";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.equals(ADD_ALL_COLUMNS_PREFIX)) {
            return new AddAllColumnsCommand();
        }
        if (c.equals(REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX)) {
            return new RemoveNonDefaultColumnsCommand();
        }
        if (c.startsWith(ADD_COLUMN_PREFIX)) {
            String content = c.substring(ADD_COLUMN_PREFIX.length());
            return new AddColumnCommand(content);
        }
        if (c.startsWith(REMOVE_COLUMN_PREFIX)) {
            String content = c.substring(REMOVE_COLUMN_PREFIX.length());
            return new RemoveColumnCommand(content);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() <= ADD_COLUMN_PREFIX.length() && ADD_COLUMN_PREFIX.startsWith(prefix) || prefix.length() <= ADD_ALL_COLUMNS_PREFIX.length() && ADD_ALL_COLUMNS_PREFIX.startsWith(prefix) || prefix.length() <= REMOVE_COLUMN_PREFIX.length() && REMOVE_COLUMN_PREFIX.startsWith(prefix) || prefix.length() <= REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX.length() && REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Adds/removes columns from the table or tree output");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  add column <column>");
        System.out.println("  add all columns");
        System.out.println("  remove column <column>");
        System.out.println("  remove all non-default columns");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <column>               The name of the column to add or remove by.");
        System.out.println("                         The range of valid names is specific for each statistic or tree.");
        System.out.println("                         (All possible column names are shown in case the name is unknown.)");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        String column;
        ColumnResourceController<TypedTableModel> controller;
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController || context instanceof TreeResourceController || context instanceof ValueSetResourceController)) {
            return;
        }
        if (ADD_ALL_COLUMNS_PREFIX.startsWith(commandPrefix)) {
            commands.add(ADD_ALL_COLUMNS_PREFIX);
        }
        if (REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX.startsWith(commandPrefix)) {
            commands.add(REMOVE_ALL_NON_DEFAULT_COLUMNS_PREFIX);
        }
        TypedColumnSpec spec = null;
        String[] currentVisibility = null;
        if (context instanceof TableResourceController) {
            controller = (TableResourceController)context;
            spec = ((TypedTableModel)controller.getModel()).getSpec();
            currentVisibility = ((TypedTableModel)controller.getModel()).getColumnVisibility().split("[|]");
        } else if (context instanceof TreeResourceController) {
            controller = (TreeResourceController)context;
            spec = ((TypedTreeModel)controller.getModel()).getSpec();
            currentVisibility = ((TypedTreeModel)controller.getModel()).getColumnVisibility().split("[|]");
        }
        if (ADD_COLUMN_PREFIX.startsWith(commandPrefix) && ADD_COLUMN_PREFIX.length() > commandPrefix.length()) {
            commands.add(ADD_COLUMN_PREFIX);
        }
        if (commandPrefix.startsWith(ADD_COLUMN_PREFIX) && spec != null) {
            column = commandPrefix.substring(ADD_COLUMN_PREFIX.length()).trim();
            HashSet<String> sets = new HashSet<String>(Arrays.asList(ColumnVisibilityCommandFactory.getVisibilitySets(spec)));
            sets.removeAll(Arrays.asList(currentVisibility));
            for (String set : sets) {
                String columnName = set.toLowerCase();
                if (!columnName.startsWith(column)) continue;
                commands.add(ADD_COLUMN_PREFIX + columnName);
            }
        }
        if (REMOVE_COLUMN_PREFIX.startsWith(commandPrefix) && REMOVE_COLUMN_PREFIX.length() > commandPrefix.length()) {
            commands.add(REMOVE_COLUMN_PREFIX);
        }
        if (commandPrefix.startsWith(REMOVE_COLUMN_PREFIX) && spec != null) {
            column = commandPrefix.substring(REMOVE_COLUMN_PREFIX.length()).trim();
            for (String set : currentVisibility) {
                String columnName = set.toLowerCase();
                if (!columnName.startsWith(column)) continue;
                commands.add(REMOVE_COLUMN_PREFIX + columnName);
            }
        }
    }

    public static String[] getVisibilitySets(TypedColumnSpec spec) {
        VisibilitySet[] visibilitySets = spec.getColumnVisibilitySets();
        String[] result = new String[visibilitySets.length];
        for (int i = 0; i < visibilitySets.length; ++i) {
            result[i] = visibilitySets[i].getId();
        }
        return result;
    }

    public static String getColumnId(TypedColumnSpec spec, String column) {
        for (String set : ColumnVisibilityCommandFactory.getVisibilitySets(spec)) {
            if (!column.equals(set.toLowerCase())) continue;
            return set;
        }
        return null;
    }

    public static void printPossibleColumns(TypedColumnSpec spec) {
        System.err.println("Available Columns:");
        for (String set : ColumnVisibilityCommandFactory.getVisibilitySets(spec)) {
            System.err.println("  " + set.toLowerCase());
        }
    }
}

