/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommand;
import java.io.IOException;

public final class CompareCommand
implements ReportCommand {
    private final String name;

    public CompareCommand(String name) {
        this.name = name;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (!(input instanceof TableResourceController)) {
            throw new JvmProfReportException("Unsupported controller type for comparison: " + input.getClass().getName());
        }
        TableResourceController currentController = (TableResourceController)input;
        Object oldInput = context.getSavedController(this.name);
        if (!(oldInput instanceof TableResourceController)) {
            throw new JvmProfReportException("Unsupported cached controller type for comparison: " + input.getClass().getName());
        }
        TableResourceController oldController = (TableResourceController)oldInput;
        if (!currentController.isComparableWith(oldController)) {
            throw new JvmProfReportException("The cached statistic is not comparable with the current statistic");
        }
        try {
            TableResourceController comparison = currentController.getComparison(oldController);
            ShowStatisticCommand.ensureContentCreated(comparison);
            ShowStatisticCommand.makeInitial(comparison);
            if (context.isInteractive()) {
                System.out.println("Comparison with cached statistic '" + this.name + "' yielded " + ((TypedTableModel)comparison.getModel()).getNrOfItems() + " entries.");
            }
            return context.changeContext(comparison);
        }
        catch (IOException e) {
            throw new JvmProfReportException("Exception while comparing statistics: " + e.getMessage());
        }
    }
}

