/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.CompareCommand;
import java.util.List;

public final class CompareCommandFactory
implements ReportCommandFactory {
    private static final String COMPARE_PREFIX = "compare with cache";
    private static final String NAMED_COMPARE_PREFIX = "compare with cache name=";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.equals(COMPARE_PREFIX)) {
            return new CompareCommand("OLD");
        }
        if (c.startsWith(NAMED_COMPARE_PREFIX)) {
            String name = c.substring(NAMED_COMPARE_PREFIX.length()).trim();
            return new CompareCommand(name);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !COMPARE_PREFIX.startsWith(prefix = commandPrefix.trim())) {
            return false;
        }
        System.out.println("Compare the current statistic with a cached statistic");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  compare with cache");
        System.out.println("  compare with cache name=<entry-name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <entry-name>           The optional name of the cached statistic.");
        System.out.println("                         The default name is 'OLD'.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController)) {
            return;
        }
        if (COMPARE_PREFIX.startsWith(commandPrefix)) {
            commands.add(COMPARE_PREFIX);
        }
        if (commandPrefix.length() > COMPARE_PREFIX.length() && NAMED_COMPARE_PREFIX.startsWith(commandPrefix)) {
            commands.add(NAMED_COMPARE_PREFIX);
        }
    }
}

