/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.DefineComponentCommand;
import com.sap.jvm.profiling.tools.report.command.DeleteComponentCommand;
import java.util.List;

public final class ComponentCommandFactory
implements ReportCommandFactory {
    private static final String DEFINE_COMPONENT_PREFIX = "define component ";
    private static final String DELETE_COMPONENT_PREFIX = "delete component ";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String nameAndPattern;
        int separator;
        String c = command.trim();
        if (c.startsWith(DELETE_COMPONENT_PREFIX)) {
            String name = c.substring(DELETE_COMPONENT_PREFIX.length()).trim();
            return new DeleteComponentCommand(name);
        }
        if (c.startsWith(DEFINE_COMPONENT_PREFIX) && (separator = (nameAndPattern = c.substring(DEFINE_COMPONENT_PREFIX.length()).trim()).indexOf(61)) > 0) {
            String name = nameAndPattern.substring(0, separator);
            String pattern = nameAndPattern.substring(separator + 1);
            return new DefineComponentCommand(name, pattern);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !DEFINE_COMPONENT_PREFIX.startsWith(prefix = commandPrefix.trim()) && !DELETE_COMPONENT_PREFIX.startsWith(prefix)) {
            return false;
        }
        System.out.println("Add/remove definitions of components to be used in the filter statistics/trees");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  define component <name>=<pattern>");
        System.out.println("  delete component <name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The name of the component to add/remove.");
        System.out.println("  <pattern>              The package/class/method pattern of the component to add.");
        System.out.println("                         The pattern can contain '*' and '?' wildcards.");
        System.out.println("                         Example: 'java.lang.*' matches all classes in the package java.lang and its subpackages.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (DEFINE_COMPONENT_PREFIX.startsWith(commandPrefix)) {
            commands.add(DEFINE_COMPONENT_PREFIX);
        }
        if (DELETE_COMPONENT_PREFIX.startsWith(commandPrefix)) {
            commands.add(DELETE_COMPONENT_PREFIX);
        }
    }
}

