/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.presentation.graph.TimeSeriesUtils;
import com.sap.jvm.profiling.presentation.graph.ValueSetUtils;
import com.sap.jvm.profiling.presentation.table.TableUtils;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ExportCommandFactory;
import com.sap.jvm.profiling.viewer.CSVModelExporter;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import com.sap.jvm.profiling.viewer.table.TableModel;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public final class CsvExportCommand
implements ReportCommand {
    private final String file;
    private final boolean selectionOnly;

    public CsvExportCommand(String file, boolean selectionOnly) {
        this.file = file;
        this.selectionOnly = selectionOnly;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        CSVModelExporter exporter;
        Object input = context.getController();
        if (!(input instanceof ResourceController)) {
            throw new JvmProfReportException("Unknown input for export command.");
        }
        ExportCommandFactory.checkOverwrite(context, this.file);
        ResourceController rc = (ResourceController)input;
        Object model = rc.getModel();
        if (model instanceof TableModel) {
            exporter = TableUtils.getCSVExporter((TableModel)model, this.selectionOnly);
        } else if (model instanceof TreeModel) {
            exporter = TreeUtils.getCSVExporter((TreeModel)model, this.selectionOnly);
        } else if (model instanceof ValueSetModel) {
            exporter = ValueSetUtils.getCSVExporter((ValueSetModel)model);
        } else if (model instanceof TimeSeriesModel) {
            exporter = TimeSeriesUtils.getCSVExporter((TimeSeriesModel)model);
        } else {
            throw new JvmProfReportException("Unknown model type: " + model.getClass().getName());
        }
        BufferedWriter stream = null;
        try {
            File directory = new File(this.file).getParentFile();
            if (directory != null && !directory.exists()) {
                directory.mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(this.file);
            stream = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8"));
            if (context.isInteractive()) {
                System.out.print("Exporting profiling data to file '" + this.file + "'... ");
            }
            ProgressReporter reporter = new ProgressReporter();
            exporter.writeCSV(stream, context.getDecimalPoint(), context.getComma(), context.includeColumnTitles(), reporter);
            reporter.finish();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            ReportExecutionContext reportExecutionContext = context;
            return reportExecutionContext;
        }
        catch (IOException e) {
            if (context.isInteractive()) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("Error while exporting data: " + e.getMessage());
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

