/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.presentation.graph.TimeSeriesUtils;
import com.sap.jvm.profiling.presentation.graph.ValueSetUtils;
import com.sap.jvm.profiling.presentation.table.TableUtils;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ExportCommandFactory;
import com.sap.jvm.profiling.viewer.ExcelModelExporter;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import com.sap.jvm.profiling.viewer.table.TableModel;
import com.sap.jvm.profiling.viewer.tree.TreeModel;
import java.io.File;
import java.io.IOException;

public final class ExcelExportCommand
implements ReportCommand {
    private final String file;
    private final String title;
    private final boolean selectionOnly;

    public ExcelExportCommand(String file, String title, boolean selectionOnly) {
        this.file = file;
        this.title = title;
        this.selectionOnly = selectionOnly;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        ExcelModelExporter exporter;
        Object input = context.getController();
        if (!(input instanceof ResourceController)) {
            throw new JvmProfReportException("Unknown input for export command.");
        }
        ExportCommandFactory.checkOverwrite(context, this.file);
        ResourceController rc = (ResourceController)input;
        Object model = rc.getModel();
        if (model instanceof TableModel) {
            exporter = TableUtils.getExcelExporter((TableModel)model, this.selectionOnly);
        } else if (model instanceof TreeModel) {
            exporter = TreeUtils.getExcelExporter((TreeModel)model, this.selectionOnly);
        } else if (model instanceof ValueSetModel) {
            exporter = ValueSetUtils.getExcelExporter((ValueSetModel)model);
        } else if (model instanceof TimeSeriesModel) {
            exporter = TimeSeriesUtils.getExcelExporter((TimeSeriesModel)model);
        } else {
            throw new JvmProfReportException("Unknown model type: " + model.getClass().getName());
        }
        try {
            if (context.isInteractive()) {
                System.out.print("Exporting profiling data to file '" + this.file + "'... ");
            }
            ProgressReporter reporter = new ProgressReporter();
            exporter.writeExcel(new File(this.file), true, context.includeColumnTitles(), this.title, reporter);
            reporter.finish();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        catch (IOException e) {
            if (context.isInteractive()) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("Error while exporting data: " + e.getMessage());
        }
    }
}

