/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.viewer.tree.TreeModelExpander;

public final class ExpandAllCommand
implements ReportCommand {
    private final int expansionDepth;

    public ExpandAllCommand(int expansionDepth) {
        this.expansionDepth = expansionDepth;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            if (context.isInteractive()) {
                if (this.expansionDepth == Integer.MAX_VALUE) {
                    System.out.print("Expanding current tree... ");
                } else {
                    System.out.print("Expanding current tree to hierarchy level " + this.expansionDepth + "... ");
                }
            }
            TreeModelExpander expander = new TreeModelExpander(model, model.getRootItems(), this.expansionDepth);
            expander.waitUntilFinished();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for expanding all entries: " + input.getClass().getName());
    }
}

