/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.viewer.tree.TreeModelExpander;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.util.Arrays;
import java.util.HashSet;

public final class ExpandByIndexCommand
implements ReportCommand {
    private final int expansionDepth;
    private final Integer[] indices;

    public ExpandByIndexCommand(int expansionDepth, Integer[] indices) {
        this.expansionDepth = expansionDepth;
        this.indices = indices;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            if (context.isInteractive()) {
                if (this.expansionDepth == Integer.MAX_VALUE) {
                    System.out.print("Expanding tree entries " + Arrays.toString((Object[])this.indices) + "... ");
                } else {
                    System.out.print("Expanding tree entries " + Arrays.toString((Object[])this.indices) + " to hierarchy level " + this.expansionDepth + "... ");
                }
            }
            TreeModelItem[] items = new TreeModelItem[this.indices.length];
            HashSet<Integer> selected = new HashSet<Integer>(Arrays.asList(this.indices));
            TreeModelForwardIterator it = new TreeModelForwardIterator(model);
            int index = 0;
            int pos = 0;
            while (it.hasNext()) {
                if (selected.contains(index)) {
                    items[pos] = it.next();
                    ++pos;
                } else {
                    it.next();
                }
                ++index;
            }
            for (int i = 0; i < items.length; ++i) {
                if (items[i] != null) continue;
                throw new JvmProfReportException("Expansion index out of range: " + this.indices[i]);
            }
            TreeModelExpander expander = new TreeModelExpander(model, items, this.expansionDepth);
            expander.waitUntilFinished();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for expansion by index: " + input.getClass().getName());
    }
}

