/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ExpandAllCommand;
import com.sap.jvm.profiling.tools.report.command.ExpandByIndexCommand;
import java.util.ArrayList;
import java.util.List;

public final class ExpandCommandFactory
implements ReportCommandFactory {
    private static final String EXPAND_ALL_PREFIX = "expand all";
    private static final String EXPAND_BY_INDEX_PREFIX = "expand by index ";
    private static final String EXPANSION_LEVEL_PREFIX = "depth=";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String depth;
        String c = command.trim();
        if (command.startsWith(EXPAND_ALL_PREFIX)) {
            if (command.length() == EXPAND_ALL_PREFIX.length()) {
                return new ExpandAllCommand(Integer.MAX_VALUE);
            }
            depth = command.substring(EXPAND_ALL_PREFIX.length()).trim();
            if (depth.startsWith(EXPANSION_LEVEL_PREFIX)) {
                String level = depth.substring(EXPANSION_LEVEL_PREFIX.length()).trim();
                try {
                    return new ExpandAllCommand(Integer.parseInt(level));
                }
                catch (NumberFormatException e) {
                    throw new JvmProfReportException("Invalid maximum expansion depth specified: " + level);
                }
            }
        }
        if (c.startsWith(EXPAND_BY_INDEX_PREFIX)) {
            depth = command.substring(EXPAND_BY_INDEX_PREFIX.length()).trim();
            int level = Integer.MAX_VALUE;
            if (depth.startsWith(EXPANSION_LEVEL_PREFIX)) {
                String levelPart = depth.substring(EXPANSION_LEVEL_PREFIX.length()).trim();
                int separatorIndex = levelPart.indexOf(32);
                if (separatorIndex < 0) {
                    separatorIndex = levelPart.length() - 1;
                }
                depth = levelPart.substring(separatorIndex).trim();
                levelPart = levelPart.substring(0, separatorIndex);
                try {
                    level = Integer.parseInt(levelPart);
                }
                catch (NumberFormatException e) {
                    throw new JvmProfReportException("Invalid maximum expansion depth specified: " + levelPart);
                }
            }
            String indicesPart = depth;
            String[] indicesStrings = indicesPart.split(" ");
            ArrayList<Integer> indices = new ArrayList<Integer>();
            for (String s : indicesStrings) {
                if ("".equals(s)) continue;
                try {
                    indices.add(Integer.parseInt(s));
                }
                catch (NumberFormatException e) {
                    throw new JvmProfReportException("Invalid index specified: " + s);
                }
            }
            return new ExpandByIndexCommand(level, indices.toArray(new Integer[indices.size()]));
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() <= EXPAND_ALL_PREFIX.length() && EXPAND_ALL_PREFIX.startsWith(prefix) || prefix.length() <= EXPAND_BY_INDEX_PREFIX.length() && EXPAND_BY_INDEX_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Expands the current tree");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  expand all [depth=<expansion-depth>]");
        System.out.println("  expand by index [depth=<expansion-depth>] <indices>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <expansion-depth>      Maximum number of hierarchy levels to expand.");
        System.out.println("                         The default is to expand all levels.");
        System.out.println("  <indices>              An arbitrary list of indices to expand separated by ' ' characters.");
        System.out.println("                         The first entry has the index 0.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TreeResourceController)) {
            return;
        }
        this.getCommandProposalsImpl(commandPrefix, commands, EXPAND_ALL_PREFIX);
        this.getCommandProposalsImpl(commandPrefix, commands, EXPAND_BY_INDEX_PREFIX);
    }

    private void getCommandProposalsImpl(String commandPrefix, List<String> commands, String expandPrefix) {
        String depthPrefix;
        if (expandPrefix.startsWith(commandPrefix) && expandPrefix.length() > commandPrefix.length()) {
            commands.add(expandPrefix);
        }
        if (commandPrefix.startsWith(expandPrefix) && EXPANSION_LEVEL_PREFIX.startsWith(depthPrefix = commandPrefix.substring(expandPrefix.length()).trim())) {
            boolean hasSpace = expandPrefix.endsWith(" ");
            commands.add(expandPrefix + (hasSpace ? "" : " ") + EXPANSION_LEVEL_PREFIX);
        }
    }
}

