/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ReportResourceController;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.CsvExportCommand;
import com.sap.jvm.profiling.tools.report.command.ExcelExportCommand;
import com.sap.jvm.profiling.tools.report.command.HtmlExportCommand;
import com.sap.jvm.profiling.tools.report.command.XmlExportCommand;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ExportCommandFactory
implements ReportCommandFactory {
    private static final String EXPORT_PREFIX = "export as ";
    private static final String EXPORT_SELECTION_PREFIX = "export selection as ";
    private static final String TITLE_PREFIX = " title=";
    private static final String DEFAULT_TITLE = "Exported Data";
    private static final Map<String, ExportFactory> TYPES;

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        boolean selectionOnly = c.startsWith(EXPORT_SELECTION_PREFIX);
        if (!selectionOnly && !c.startsWith(EXPORT_PREFIX)) {
            return null;
        }
        int offset = selectionOnly ? EXPORT_SELECTION_PREFIX.length() : EXPORT_PREFIX.length();
        for (Map.Entry<String, ExportFactory> entry : TYPES.entrySet()) {
            if (!c.startsWith(entry.getKey(), offset) || !c.startsWith(" to ", offset + entry.getKey().length())) continue;
            String file = c.substring(offset + entry.getKey().length() + " to ".length()).trim();
            String title = DEFAULT_TITLE;
            int titleIndex = file.lastIndexOf(TITLE_PREFIX);
            if (titleIndex >= 0) {
                title = file.substring(titleIndex + TITLE_PREFIX.length());
                file = file.substring(0, titleIndex).trim();
            }
            return entry.getValue().create(file, title, selectionOnly);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < EXPORT_PREFIX.length() && EXPORT_PREFIX.startsWith(prefix) || prefix.length() < EXPORT_SELECTION_PREFIX.length() && EXPORT_SELECTION_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Export the current set of profiling data");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  export selection as <csv|excel|html|mhtml|xml|zipped html> to <file> [title=<caption>]");
        System.out.println("  export as <csv|excel|html|mhtml|xml|zipped html> to <file> [title=<caption>]");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <file>                 The name of the file to export the data to.");
        System.out.println("                         There must be no existing file with the given name.");
        System.out.println("  <caption>              The optional title of the exported profiling data.");
        System.out.println("                         The default is 'Exported Data'.");
        System.out.println("                         Not all export formats support the title attribute.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof ResourceController)) {
            return;
        }
        if (context instanceof SnapshotController) {
            return;
        }
        String[] exportTypes = context instanceof ReportResourceController ? new String[]{"html", "mhtml", "zipped html"} : TYPES.keySet().toArray(new String[TYPES.keySet().size()]);
        this.getCommandProposalsImpl(commandPrefix, commands, EXPORT_PREFIX, exportTypes);
        if (!(context instanceof ReportResourceController)) {
            this.getCommandProposalsImpl(commandPrefix, commands, EXPORT_SELECTION_PREFIX, exportTypes);
        }
    }

    private void getCommandProposalsImpl(String commandPrefix, List<String> commands, String exportPrefix, String[] exportTypes) {
        if (exportPrefix.startsWith(commandPrefix) && exportPrefix.length() > commandPrefix.length()) {
            commands.add(exportPrefix);
        }
        if (commandPrefix.startsWith(exportPrefix)) {
            String typePrefix = commandPrefix.substring(exportPrefix.length()).trim();
            for (String type : exportTypes) {
                String toPrefix;
                if (type.startsWith(typePrefix) && type.length() > typePrefix.length()) {
                    commands.add(exportPrefix + type + " to ");
                }
                if (!typePrefix.startsWith(type) || !"to".startsWith(toPrefix = typePrefix.substring(type.length()).trim())) continue;
                commands.add(exportPrefix + type + " to ");
            }
        }
    }

    static void checkOverwrite(ReportExecutionContext context, String file) throws JvmProfReportException {
        if (new File(file).exists()) {
            if (context.getOverwrite()) {
                if (!new File(file).delete()) {
                    throw new JvmProfReportException("File \"" + file + "\" could not be deleted.");
                }
            } else {
                throw new JvmProfReportException("File \"" + file + "\" already exists. Use 'set overwrite=true' to overwite existing files.");
            }
        }
    }

    static {
        HashMap<String, ExportFactory> types = new HashMap<String, ExportFactory>();
        types.put("csv", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return new CsvExportCommand(file, selectionOnly);
            }
        });
        types.put("excel", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return new ExcelExportCommand(file, title, selectionOnly);
            }
        });
        types.put("html", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return HtmlExportCommand.createHtmlExport(file, title, selectionOnly);
            }
        });
        types.put("mhtml", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return HtmlExportCommand.createMhtmlExport(file, title, selectionOnly);
            }
        });
        types.put("xml", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return new XmlExportCommand(file, selectionOnly);
            }
        });
        types.put("zipped html", new ExportFactory(){

            @Override
            public ReportCommand create(String file, String title, boolean selectionOnly) {
                return HtmlExportCommand.createZippedHtmlExport(file, title, selectionOnly);
            }
        });
        TYPES = Collections.unmodifiableMap(types);
    }

    private static interface ExportFactory {
        public ReportCommand create(String var1, String var2, boolean var3);
    }
}

