/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.snapshot.filter.FilterParseException;
import com.sap.jvm.profiling.snapshot.filter.MethodFilter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class FilterCommand
implements ReportCommand {
    private final String pattern;

    public FilterCommand(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (!(input instanceof TableResourceController)) {
            throw new JvmProfReportException("Unsupported controller type for filter command: " + input.getClass().getName());
        }
        TableResourceController controller = (TableResourceController)input;
        ProfilingSession session = context.getFileController().getProfilingSession();
        try {
            Method method = controller.getClass().getMethod("filterByMethod", MethodFilter[].class);
            MethodFilter filter = new MethodFilter(session, this.pattern, this.pattern);
            MethodFilter[] params = new MethodFilter[]{filter};
            Object result = method.invoke((Object)controller, new Object[]{params});
            ShowStatisticCommand.ensureContentCreated(result);
            ShowStatisticCommand.makeInitial(result);
            if (context.isInteractive()) {
                String entries;
                if (result instanceof TableResourceController) {
                    TableResourceController newController = (TableResourceController)result;
                    entries = "" + ((TypedTableModel)newController.getModel()).getNrOfItems();
                } else {
                    entries = "unknown number of";
                }
                System.out.println("Filtering by '" + this.pattern + "' yielded " + entries + " entries.");
            }
            return context.changeContext(result);
        }
        catch (NoSuchMethodException e) {
            throw new JvmProfReportException("Unsupported controller type for filter command: " + input.getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new JvmProfReportException("Error during report: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new JvmProfReportException("Error during report: " + e.getCause().getMessage());
        }
        catch (FilterParseException e) {
            throw new JvmProfReportException("Error during report: " + e.getMessage());
        }
    }
}

