/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.FilterByAllocatedClassCommand;
import com.sap.jvm.profiling.tools.report.command.FilterCommand;
import java.util.List;

public final class FilterCommandFactory
implements ReportCommandFactory {
    private static final String FILTER_PREFIX = "filter by ";
    private static final String FILTER_BY_ALLOCATED_CLASS_PREFIX = "filter by allocated class ";

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(FILTER_PREFIX)) {
            return null;
        }
        if (c.startsWith(FILTER_BY_ALLOCATED_CLASS_PREFIX)) {
            String pattern = c.substring(FILTER_BY_ALLOCATED_CLASS_PREFIX.length()).trim();
            return new FilterByAllocatedClassCommand(pattern);
        }
        String pattern = c.substring(FILTER_PREFIX.length()).trim();
        return new FilterCommand(pattern);
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < FILTER_PREFIX.length() && FILTER_PREFIX.startsWith(prefix) || prefix.length() >= FILTER_PREFIX.length() && prefix.startsWith(FILTER_PREFIX))) {
            return false;
        }
        System.out.println("Filter the profiling data by a given method pattern");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  filter by <pattern>");
        System.out.println("  filter by allocated class <pattern>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <pattern>              The class/method pattern to filter by.");
        System.out.println("                         The pattern can contain '*' and '?' wildcards.");
        System.out.println("                         Example: '*.hashCode()' matches all methods named hashCode with no arguments.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController) && !(context instanceof TreeResourceController)) {
            return;
        }
        ResourceController controller = (ResourceController)context;
        ProfilingSession session = controller.getController().getProfilingSession();
        SnapshotResourceManager resourceManager = SnapshotResourceManagerFactory.get(session);
        Snapshot snapshot = resourceManager.getSnapshot(controller.getResourceName());
        if (snapshot.getType() == SnapshotType.ALLOCATION_SNAPSHOT && FILTER_BY_ALLOCATED_CLASS_PREFIX.startsWith(commandPrefix) && FILTER_BY_ALLOCATED_CLASS_PREFIX.length() > commandPrefix.length()) {
            commands.add(FILTER_BY_ALLOCATED_CLASS_PREFIX);
        }
        if (!(context instanceof TableResourceController)) {
            return;
        }
        if (FILTER_PREFIX.startsWith(commandPrefix) && FILTER_PREFIX.length() > commandPrefix.length()) {
            commands.add(FILTER_PREFIX);
        }
    }
}

