/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommand;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public final class GenericInliningCommand
implements ReportCommand {
    private final String methodName;
    private final boolean isAdd;

    public GenericInliningCommand(String methodName, boolean isAdd) {
        this.methodName = methodName;
        this.isAdd = isAdd;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        try {
            Method method = input.getClass().getMethod(this.methodName, new Class[0]);
            Object result = method.invoke(input, new Object[0]);
            ShowStatisticCommand.ensureContentCreated(result);
            ShowStatisticCommand.makeInitial(result);
            if (context.isInteractive()) {
                String entries;
                if (result instanceof TableResourceController) {
                    TableResourceController newController = (TableResourceController)result;
                    entries = "" + ((TypedTableModel)newController.getModel()).getNrOfItems();
                } else if (result instanceof TreeResourceController) {
                    TreeResourceController controller = (TreeResourceController)result;
                    entries = "" + ((TypedTreeModel)controller.getModel()).getRootItems().length;
                } else {
                    entries = "unknown number of";
                }
                System.out.println((this.isAdd ? "Adding" : "Removing") + " the inlining yielded " + entries + " entries.");
            }
            return context.changeContext(result);
        }
        catch (NoSuchMethodException e) {
            throw new JvmProfReportException("Unsupported controller type for filter command: " + input.getClass().getName());
        }
        catch (IllegalAccessException e) {
            throw new JvmProfReportException("Error during report: " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new JvmProfReportException("Error during report: " + e.getCause().getMessage());
        }
    }
}

