/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.GraphTypeCommand;
import java.util.List;

public class GraphTypeCommandFactory
implements ReportCommandFactory {
    private static String GRAPH_TYPE_PREFIX = "graph type ";
    private static String[] CHOICES = new String[]{GRAPH_TYPE_PREFIX + "pie", GRAPH_TYPE_PREFIX + "bar", GRAPH_TYPE_PREFIX + "percent-bar"};

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(GRAPH_TYPE_PREFIX)) {
            return null;
        }
        String file = c.substring(GRAPH_TYPE_PREFIX.length()).trim();
        return new GraphTypeCommand(file);
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < GRAPH_TYPE_PREFIX.length() && GRAPH_TYPE_PREFIX.startsWith(prefix) || prefix.length() >= GRAPH_TYPE_PREFIX.length() && prefix.startsWith(GRAPH_TYPE_PREFIX))) {
            return false;
        }
        System.out.println("Sets the graph type for appropriate statistics");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  graph type <pie|bar|percent-bar>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <pie>                  Displays the data as a pie graph.");
        System.out.println("  <bar>                  Displays the data as a bar graph.");
        System.out.println("  <percent-bar>          Displays the data as a bar graph using percentages.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        Object context = executionContext.getController();
        if (!(context instanceof ValueSetResourceController)) {
            return;
        }
        if (GRAPH_TYPE_PREFIX.startsWith(commandPrefix) && !GRAPH_TYPE_PREFIX.equals(commandPrefix)) {
            commands.add(GRAPH_TYPE_PREFIX);
        } else {
            for (String choice : CHOICES) {
                if (!choice.startsWith(commandPrefix)) continue;
                commands.add(choice);
            }
        }
    }
}

