/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportCommandRegistry;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.HelpCommand;
import java.util.List;

public final class HelpCommandFactory
implements ReportCommandFactory {
    private static final String HELP_PREFIX = "help";
    private final ReportCommandRegistry registry;

    public HelpCommandFactory(ReportCommandRegistry registry) {
        this.registry = registry;
    }

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.startsWith(HELP_PREFIX)) {
            String prefix = null;
            if (c.length() > HELP_PREFIX.length() + 1) {
                prefix = c.substring(HELP_PREFIX.length() + 1).trim();
            }
            return new HelpCommand(this.registry.getCommandFactories(), prefix);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !HELP_PREFIX.startsWith(prefix = commandPrefix.trim())) {
            return false;
        }
        System.out.println("Print the usage information of the available commands");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  help");
        System.out.println("  help <command prefix>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <command prefix>       The optional prefix of a report command.");
        System.out.println("                         Without prefix the usage information of all commands is shown.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (HELP_PREFIX.startsWith(commandPrefix)) {
            commands.add(HELP_PREFIX);
        }
    }
}

