/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.presentation.graph.TimeSeriesUtils;
import com.sap.jvm.profiling.presentation.graph.ValueSetUtils;
import com.sap.jvm.profiling.presentation.report.ReportUtils;
import com.sap.jvm.profiling.presentation.table.TableUtils;
import com.sap.jvm.profiling.presentation.tree.TreeUtils;
import com.sap.jvm.profiling.presentation.typed.RendererThemeSpec;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ExportCommandFactory;
import com.sap.jvm.profiling.viewer.HTMLModelExporter;
import com.sap.jvm.profiling.viewer.OSThemeSpec;
import com.sap.jvm.profiling.viewer.graph.ValueSetModel;
import com.sap.jvm.profiling.viewer.series.TimeSeriesModel;
import java.io.File;
import java.io.IOException;

public final class HtmlExportCommand
implements ReportCommand {
    private final String file;
    private final String title;
    private final boolean selectionOnly;
    private final boolean isHtml;
    private final boolean isMhtml;
    private final boolean isZippedHtml;

    private HtmlExportCommand(String file, String title, boolean selectionOnly, boolean isHtml, boolean isMhtml, boolean isZippedHtml) {
        this.title = title;
        this.selectionOnly = selectionOnly;
        this.isHtml = isHtml;
        this.isMhtml = isMhtml;
        this.isZippedHtml = isZippedHtml;
        if (isHtml && !isMhtml && !isZippedHtml) {
            File target = new File(file);
            if (target.isDirectory()) {
                target = new File(target, "index.html");
                this.file = target.getPath();
            } else {
                this.file = file;
            }
        } else {
            this.file = file;
        }
    }

    public static HtmlExportCommand createHtmlExport(String file, String title, boolean selectionOnly) {
        return new HtmlExportCommand(file, title, selectionOnly, true, false, false);
    }

    public static HtmlExportCommand createMhtmlExport(String file, String title, boolean selectionOnly) {
        return new HtmlExportCommand(file, title, selectionOnly, false, true, false);
    }

    public static HtmlExportCommand createZippedHtmlExport(String file, String title, boolean selectionOnly) {
        return new HtmlExportCommand(file, title, selectionOnly, false, false, true);
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        HTMLModelExporter exporter;
        Object input = context.getController();
        if (!(input instanceof ResourceController)) {
            throw new JvmProfReportException("Unknown input for export command.");
        }
        ExportCommandFactory.checkOverwrite(context, this.file);
        ResourceController rc = (ResourceController)input;
        Object model = rc.getModel();
        if (model instanceof TypedTableModel) {
            exporter = TableUtils.getHTMLExporter((TypedTableModel)model, new OSThemeSpec(), this.selectionOnly, ((TypedTableModel)model).getSpec().getColumnsToSum());
        } else if (model instanceof TypedTreeModel) {
            exporter = TreeUtils.getHTMLExporter((TypedTreeModel)model, new OSThemeSpec(), this.selectionOnly);
        } else if (model instanceof ValueSetModel) {
            exporter = ValueSetUtils.getHTMLExporter((ValueSetModel)model, new OSThemeSpec());
        } else if (model instanceof TypedReportModel) {
            exporter = ReportUtils.getHTMLExporter((TypedReportModel)model, new RendererThemeSpec(new OSThemeSpec()));
        } else if (model instanceof TimeSeriesModel) {
            exporter = TimeSeriesUtils.getHTMLExporter((TimeSeriesModel)model, new OSThemeSpec());
        } else {
            throw new JvmProfReportException("Unknown model type: " + model.getClass().getName());
        }
        try {
            exporter.setFont(context.getFont());
            if (context.isInteractive()) {
                System.out.print("Exporting profiling data to file '" + this.file + "'... ");
            }
            ProgressReporter reporter = new ProgressReporter();
            if (this.isHtml) {
                exporter.writeHTML(new File(this.file), this.title, true, false, true, reporter);
            } else if (this.isMhtml) {
                exporter.writeMHTML(new File(this.file), this.title, true, false, true, reporter);
            } else if (this.isZippedHtml) {
                exporter.writeZipped(new File(this.file), this.title, true, false, true, reporter);
            }
            reporter.finish();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        catch (IOException e) {
            if (context.isInteractive()) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("Error while exporting data: " + e.getMessage());
        }
    }
}

