/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ColumnResourceController;
import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.ReportResourceController;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.controller.model.ModelController;
import com.sap.jvm.profiling.controller.model.SnapshotController;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.presentation.typed.TypedReportModel;
import com.sap.jvm.profiling.presentation.typed.TypedSelectableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.OpenSnapshotCommandFactory;
import com.sap.jvm.profiling.tools.report.command.ShowStatisticCommand;
import java.util.Arrays;
import java.util.HashSet;

public final class InfoCommand
implements ReportCommand {
    private static final String CONTROLLER_SUFFIX = "ControllerImpl";

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        System.out.println("Current report context:");
        if (input instanceof FileController) {
            FileController controller = (FileController)input;
            System.out.println("  Profiling file: " + controller.getFilename());
            ModelController modelController = controller.getModelController();
            for (ProfilingTraceType trace : ProfilingTraceType.values()) {
                SnapshotStore<?> store;
                if (!modelController.hasModel(trace) || (store = modelController.getModel(trace).getSnapshotStore()).size() == 0) continue;
                String name = OpenSnapshotCommandFactory.getTraceName(trace);
                System.out.println("  Available " + name + " snapshots:");
                for (int i = 0; i < store.size(); ++i) {
                    System.out.println("    " + store.get(i).getName() + " (index " + i + ")");
                }
            }
        } else if (input instanceof SnapshotController) {
            System.out.println("  Profiling file: " + context.getFileController().getFilename());
            SnapshotController controller = (SnapshotController)input;
            Object snapshot = controller.getSnapshot();
            System.out.println("  Current snapshot: " + snapshot.getName());
            String traceName = OpenSnapshotCommandFactory.getTraceName(snapshot.getType().getTraceType());
            System.out.println("  Snapshot type: " + traceName);
            System.out.println("  Available statistics or trees:");
            for (String statistic : ShowStatisticCommand.getPossibleStatistics(input.getClass())) {
                System.out.println("    " + statistic);
            }
        } else if (input instanceof ResourceController) {
            int i;
            String columnVisibility;
            String sortOrder;
            String column;
            TypedSelectableModel model;
            ColumnResourceController<TypedTableModel> controller;
            System.out.println("  Profiling file: " + context.getFileController().getFilename());
            ResourceController resController = (ResourceController)input;
            ProfilingSession session = resController.getController().getProfilingSession();
            SnapshotResourceManager resourceManager = SnapshotResourceManagerFactory.get(session);
            Snapshot snapshot = resourceManager.getSnapshot(resController.getResourceName());
            System.out.println("  Current snapshot: " + snapshot.getName());
            String traceName = OpenSnapshotCommandFactory.getTraceName(snapshot.getType().getTraceType());
            System.out.println("  Snapshot type: " + traceName);
            String statisticName = input.getClass().getSimpleName();
            if (statisticName.endsWith(CONTROLLER_SUFFIX)) {
                statisticName = statisticName.substring(0, statisticName.length() - CONTROLLER_SUFFIX.length());
            }
            statisticName = ShowStatisticCommand.getStatisticName(statisticName);
            System.out.println("  Current statistic/tree: " + statisticName);
            if (input instanceof TableResourceController) {
                controller = (TableResourceController)input;
                model = (TypedTableModel)controller.getModel();
                column = model.getColumnText(model.getSortedColumn()).toLowerCase();
                System.out.println("    Sorted by column: " + column);
                sortOrder = model.getSortDirection() > 0 ? " ascending" : " descending";
                System.out.println("    Sort order:" + sortOrder);
                System.out.println("    Number of table entries: " + model.getNrOfItems());
                if (model.isAnySelected()) {
                    System.out.println("    Number of selected entries: " + model.getSelectedItemIds().length);
                } else {
                    System.out.println("    No entries selected.");
                }
                columnVisibility = model.getColumnVisibility();
            } else if (input instanceof TreeResourceController) {
                controller = (TreeResourceController)input;
                model = (TypedTreeModel)controller.getModel();
                column = model.getColumnText(model.getSortedColumn()).toLowerCase();
                System.out.println("    Sorted by column: " + column);
                sortOrder = model.getSortDirection() > 0 ? " ascending" : " descending";
                System.out.println("    Sort order:" + sortOrder);
                System.out.println("    Number of root entries: " + model.getRootItems().length);
                if (model.isAnySelected()) {
                    System.out.println("    Number of selected entries: " + model.getSelectedNodes().length);
                } else {
                    System.out.println("    No entries selected.");
                }
                columnVisibility = model.getColumnVisibility();
            } else if (input instanceof ValueSetResourceController) {
                controller = (ValueSetResourceController)input;
                model = (TypedValueSetModel)controller.getModel();
                System.out.println("    Number of coulmns: " + model.getNrOfColumns());
                System.out.println("    Number of rows: " + model.getNrOfRows());
                if (model.isAnySelected()) {
                    System.out.println("    Number of selected rows: " + model.getSelectedRows().length);
                } else {
                    System.out.println("    No rows selected.");
                }
                columnVisibility = model.getColumnVisibility();
            } else {
                if (input instanceof TimeSeriesResourceController) {
                    TimeSeriesResourceController controller2 = (TimeSeriesResourceController)input;
                    TypedTimeSeriesModel model2 = (TypedTimeSeriesModel)controller2.getModel();
                    HashSet<String> visible = new HashSet<String>(Arrays.asList(model2.getVisibilitySet()));
                    for (int i2 = 0; i2 < model2.getNrOfAreas(); ++i2) {
                        if (!visible.contains(model2.getTags()[i2])) continue;
                        System.out.println("    Area '" + model2.getAreaName(i2) + "' (" + model2.getTags()[i2] + ") contains:");
                        for (int j = 0; j < model2.getAreaSize(i2); ++j) {
                            System.out.println("        Graph '" + model2.getGraphName(i2, j) + "'");
                        }
                    }
                    return context;
                }
                if (input instanceof ReportResourceController) {
                    ReportResourceController controller3 = (ReportResourceController)input;
                    TypedReportModel model3 = (TypedReportModel)controller3.getModel();
                    System.out.println("    Report title: " + model3.getTitle());
                    System.out.println("    Report output directory: " + model3.getReportDataDirectory());
                    return context;
                }
                throw new JvmProfReportException("Unknown report context: " + input.getClass().getName());
            }
            String[] visibilitySets = columnVisibility.split("[|]");
            System.out.print("  Column visibility sets: ");
            if (visibilitySets.length > 4) {
                System.out.println();
                for (i = 0; i < visibilitySets.length; ++i) {
                    System.out.println("    " + visibilitySets[i].toLowerCase());
                }
            } else {
                for (i = 0; i < visibilitySets.length; ++i) {
                    if (i != 0) {
                        System.out.print(", ");
                    }
                    System.out.print(visibilitySets[i].toLowerCase());
                }
                System.out.println();
            }
            System.out.println("  Available statistics or trees:");
            for (String statistic : ShowStatisticCommand.getPossibleStatistics(input.getClass())) {
                System.out.println("    " + statistic);
            }
        } else {
            throw new JvmProfReportException("Unknown report context: " + input.getClass().getName());
        }
        return context;
    }
}

