/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.InfoCommand;
import java.util.List;

public final class InfoCommandFactory
implements ReportCommandFactory {
    private static final String INFO_PREFIX = "info";

    @Override
    public ReportCommand create(String command) throws JvmProfReportException {
        String c = command.trim();
        if (c.startsWith(INFO_PREFIX)) {
            return new InfoCommand();
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !INFO_PREFIX.startsWith(prefix = commandPrefix.trim())) {
            return false;
        }
        System.out.println("Print information about the current report context");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  info");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (INFO_PREFIX.startsWith(commandPrefix)) {
            commands.add(INFO_PREFIX);
        }
    }
}

