/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.controller.ResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManager;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.elements.InlineByPredefinedFilter;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.GenericInliningCommand;
import com.sap.jvm.profiling.tools.report.command.InlineCommand;
import java.util.List;

public final class InliningCommandFactory
implements ReportCommandFactory {
    private static final String INLINE_PREFIX = "inline ";
    private static final String REMOVE_INLINE_PREFIX = "remove inlining";
    private static final String INLINE_JDK_CLASSES_PREFIX = "inline jdk classes";
    private static final String INLINE_JDK_IO_PREFIX = "inline jdk file i/o";
    private static final String REMOVE_JDK_IO_INLINE_PREFIX = "remove jdk file i/o inlining";
    private static final String INLINE_JDK_NET_PREFIX = "inline jdk network i/o";
    private static final String REMOVE_JDK_NET_INLINE_PREFIX = "remove jdk network i/o inlining";
    private static final String REMOVE_INLINING_METHOD = "removeInlining";
    private static final String ADD_JDK_IO_INLINING_METHOD = "addJdkIoInliner";
    private static final String REMOVE_JDK_IO_INLINING_METHOD = "removeJdkIoInlining";
    private static final String ADD_JDK_NET_INLINING_METHOD = "addJdkNetworkInliner";
    private static final String REMOVE_JDK_NET_INLINING_METHOD = "removeJdkNetworkInlining";

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (c.equals(INLINE_JDK_IO_PREFIX)) {
            return new GenericInliningCommand(ADD_JDK_IO_INLINING_METHOD, true);
        }
        if (c.equals(REMOVE_JDK_IO_INLINE_PREFIX)) {
            return new GenericInliningCommand(REMOVE_JDK_IO_INLINING_METHOD, false);
        }
        if (c.equals(INLINE_JDK_NET_PREFIX)) {
            return new GenericInliningCommand(ADD_JDK_NET_INLINING_METHOD, true);
        }
        if (c.equals(REMOVE_JDK_NET_INLINE_PREFIX)) {
            return new GenericInliningCommand(REMOVE_JDK_NET_INLINING_METHOD, false);
        }
        if (c.equals(INLINE_JDK_CLASSES_PREFIX)) {
            return new InlineCommand(InlineByPredefinedFilter.PredefinedFilter.JDK_CLASSES.pattern);
        }
        if (c.startsWith(INLINE_PREFIX)) {
            String pattern = c.substring(INLINE_PREFIX.length()).trim();
            return new InlineCommand(pattern);
        }
        if (c.equals(REMOVE_INLINE_PREFIX)) {
            return new GenericInliningCommand(REMOVE_INLINING_METHOD, false);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < INLINE_PREFIX.length() && INLINE_PREFIX.startsWith(prefix) || prefix.length() >= INLINE_PREFIX.length() && prefix.startsWith(INLINE_PREFIX) || REMOVE_INLINE_PREFIX.startsWith(prefix) || REMOVE_JDK_IO_INLINE_PREFIX.startsWith(prefix) || REMOVE_JDK_NET_INLINE_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Add/remove inlining of the profiling data by a given pattern");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  inline <pattern>");
        System.out.println("  inline jdk classes");
        System.out.println("  inline jdk file i/o");
        System.out.println("  inline jdk network i/o");
        System.out.println("  remove inlining");
        System.out.println("  remove jdk file i/o inlining");
        System.out.println("  remove jdk network i/o inlining");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <pattern>              The package/class/method pattern to use for the inlining.");
        System.out.println("                         The pattern can contain '*' and '?' wildcards.");
        System.out.println("                         Example: 'java.lang.*' inlines all classes and methods in the java.lang package and its subpackages.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        ResourceController controller;
        ProfilingSession session;
        SnapshotResourceManager resourceManager;
        Snapshot snapshot;
        Object context = executionContext.getController();
        if (!(context instanceof TableResourceController) && !(context instanceof TreeResourceController)) {
            return;
        }
        if (INLINE_PREFIX.startsWith(commandPrefix) && INLINE_PREFIX.length() > commandPrefix.length()) {
            commands.add(INLINE_PREFIX);
        }
        if (REMOVE_INLINE_PREFIX.startsWith(commandPrefix) && REMOVE_INLINE_PREFIX.length() > commandPrefix.length()) {
            commands.add(REMOVE_INLINE_PREFIX);
        }
        if (INLINE_JDK_CLASSES_PREFIX.startsWith(commandPrefix) && INLINE_JDK_CLASSES_PREFIX.length() > commandPrefix.length()) {
            commands.add(INLINE_JDK_CLASSES_PREFIX);
        }
        if ((snapshot = (resourceManager = SnapshotResourceManagerFactory.get(session = (controller = (ResourceController)context).getController().getProfilingSession())).getSnapshot(controller.getResourceName())).getType() == SnapshotType.IO_SNAPSHOT) {
            if (INLINE_JDK_IO_PREFIX.startsWith(commandPrefix) && INLINE_JDK_IO_PREFIX.length() > commandPrefix.length()) {
                commands.add(INLINE_JDK_IO_PREFIX);
            }
            if (REMOVE_JDK_IO_INLINE_PREFIX.startsWith(commandPrefix) && REMOVE_JDK_IO_INLINE_PREFIX.length() > commandPrefix.length()) {
                commands.add(REMOVE_JDK_IO_INLINE_PREFIX);
            }
        }
        if (snapshot.getType() == SnapshotType.NETWORK_SNAPSHOT) {
            if (INLINE_JDK_NET_PREFIX.startsWith(commandPrefix) && INLINE_JDK_NET_PREFIX.length() > commandPrefix.length()) {
                commands.add(INLINE_JDK_NET_PREFIX);
            }
            if (REMOVE_JDK_NET_INLINE_PREFIX.startsWith(commandPrefix) && REMOVE_JDK_NET_INLINE_PREFIX.length() > commandPrefix.length()) {
                commands.add(REMOVE_JDK_NET_INLINE_PREFIX);
            }
        }
    }
}

