/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.controller.model.ModelController;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;

public final class OpenSnapshotByNameCommand
implements ReportCommand {
    private final String name;

    public OpenSnapshotByNameCommand(String name) {
        this.name = name;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        FileController controller = context.getFileController();
        ModelController modelController = controller.getModelController();
        for (Snapshot snapshot : modelController.getSnapshots()) {
            if (!snapshot.getName().equals(this.name)) continue;
            if (context.isInteractive()) {
                System.out.println("Opened snapshot with name '" + this.name + "'.");
            }
            Model<?> model = modelController.getModel(snapshot.getType().getTraceType());
            return context.changeContext(model.getSnapshotController(snapshot));
        }
        throw new JvmProfReportException("Snapshot with name \"" + this.name + "\" not found.");
    }
}

