/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.model.Model;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;

public final class OpenSnapshotByTypeCommand
implements ReportCommand {
    private final ProfilingTraceType type;
    private final String typeName;
    private final int index;

    public OpenSnapshotByTypeCommand(ProfilingTraceType type, String typeName, int index) {
        this.type = type;
        this.typeName = typeName;
        this.index = index;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        FileController controller = context.getFileController();
        Model<?> model = controller.getModelController().getModel(this.type);
        if (model == null) {
            throw new JvmProfReportException("No model found for type \"" + this.typeName + " snapshot\".");
        }
        if (this.index < 0 || this.index >= model.getSnapshotStore().size()) {
            throw new JvmProfReportException("No " + this.typeName + " snapshot with index " + this.index + " found.");
        }
        if (context.isInteractive()) {
            System.out.println("Opened " + this.typeName + " snapshot with index " + this.index + ".");
        }
        return context.changeContext(model.getSnapshotController(model.getSnapshotStore().get(this.index)));
    }
}

