/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.FileController;
import com.sap.jvm.profiling.controller.model.ModelController;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.OpenSnapshotByNameCommand;
import com.sap.jvm.profiling.tools.report.command.OpenSnapshotByTypeCommand;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class OpenSnapshotCommandFactory
implements ReportCommandFactory {
    private static final String TRACE_SUFFIX = "_trace";
    private static final String OPEN_SNAPSHOT_PREFIX = "open ";
    private static final String OPEN_SNAPSHOT_BY_NAME_PREFIX = "open snapshot ";
    private final Map<String, ProfilingTraceType> supportedTraces = new LinkedHashMap<String, ProfilingTraceType>();
    private final Map<String, String> prefixes = new HashMap<String, String>();

    public OpenSnapshotCommandFactory() {
        for (ProfilingTraceType type : ProfilingTraceType.values()) {
            if (type == ProfilingTraceType.ALL_TRACES || type == ProfilingTraceType.THREAD_HOTSPOT_TRACE) continue;
            String name = OpenSnapshotCommandFactory.getTraceName(type);
            this.supportedTraces.put(name, type);
            this.prefixes.put(OPEN_SNAPSHOT_PREFIX + name + " snapshot", name);
        }
    }

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(OPEN_SNAPSHOT_PREFIX)) {
            return null;
        }
        if (c.startsWith(OPEN_SNAPSHOT_BY_NAME_PREFIX)) {
            String name = c.substring(OPEN_SNAPSHOT_BY_NAME_PREFIX.length());
            return new OpenSnapshotByNameCommand(name);
        }
        for (Map.Entry<String, String> prefix : this.prefixes.entrySet()) {
            if (!c.startsWith(prefix.getKey())) continue;
            int index = 0;
            if (c.length() > prefix.getKey().length()) {
                try {
                    index = Integer.parseInt(c.substring(prefix.getKey().length()).trim());
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            ProfilingTraceType type = this.supportedTraces.get(prefix.getValue());
            return new OpenSnapshotByTypeCommand(type, prefix.getValue(), index);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < OPEN_SNAPSHOT_PREFIX.length() && OPEN_SNAPSHOT_PREFIX.startsWith(prefix))) {
            return false;
        }
        System.out.println("Open a profiling snapshot by name or type and index");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  open snapshot <name>");
        System.out.print("  open <");
        boolean first = true;
        for (String name : this.supportedTraces.keySet()) {
            if (!first) {
                System.out.print('|');
            }
            System.out.print(name);
            first = false;
        }
        System.out.println("> snapshot [<index>]");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The name of the snapshot.");
        System.out.println("  <index>                The index of the snapshot with the given type.");
        System.out.println("                         Default is 0, i.e. the first snapshot.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        FileController controller = executionContext.getFileController();
        ModelController modelController = controller.getModelController();
        if (OPEN_SNAPSHOT_PREFIX.startsWith(commandPrefix) && OPEN_SNAPSHOT_PREFIX.length() > commandPrefix.length()) {
            commands.add(OPEN_SNAPSHOT_PREFIX);
        }
        if (commandPrefix.startsWith(OPEN_SNAPSHOT_PREFIX)) {
            String tracePrefix = commandPrefix.substring(OPEN_SNAPSHOT_PREFIX.length()).trim();
            for (Map.Entry<String, ProfilingTraceType> trace : this.supportedTraces.entrySet()) {
                String snapshotPrefix;
                SnapshotStore<?> store;
                if (!modelController.hasModel(trace.getValue()) || (store = modelController.getModel(trace.getValue()).getSnapshotStore()).size() == 0) continue;
                String name = trace.getKey();
                if (name.startsWith(tracePrefix) && name.length() > tracePrefix.length()) {
                    commands.add(OPEN_SNAPSHOT_PREFIX + name + " snapshot");
                }
                if (!tracePrefix.startsWith(name) || !"snapshot".startsWith(snapshotPrefix = tracePrefix.substring(name.length()).trim())) continue;
                String command = OPEN_SNAPSHOT_PREFIX + name + " snapshot";
                if (store.size() == 1) {
                    commands.add(command);
                    continue;
                }
                for (int i = 0; i < store.size(); ++i) {
                    commands.add(command + " " + i);
                }
            }
        }
        if (OPEN_SNAPSHOT_BY_NAME_PREFIX.startsWith(commandPrefix) && OPEN_SNAPSHOT_BY_NAME_PREFIX.length() > commandPrefix.length()) {
            commands.add(OPEN_SNAPSHOT_BY_NAME_PREFIX);
        }
        if (commandPrefix.startsWith(OPEN_SNAPSHOT_BY_NAME_PREFIX)) {
            String namePrefix = commandPrefix.substring(OPEN_SNAPSHOT_BY_NAME_PREFIX.length()).trim();
            for (Snapshot snapshot : modelController.getSnapshots()) {
                if (!snapshot.getName().startsWith(namePrefix)) continue;
                commands.add(OPEN_SNAPSHOT_BY_NAME_PREFIX + snapshot.getName());
            }
        }
    }

    public static String getTraceName(ProfilingTraceType type) {
        String name = type.name().toLowerCase();
        if (name.endsWith(TRACE_SUFFIX)) {
            name = name.substring(0, name.length() - TRACE_SUFFIX.length());
        }
        name = name.replace('_', ' ');
        if (type == ProfilingTraceType.IO_TRACE) {
            name = "file";
        }
        return name;
    }
}

