/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ReadFileCommand;
import java.io.File;
import java.util.List;

public final class ReadCommandFactory
implements ReportCommandFactory {
    private static final String READ_FILE_PREFIX = "read file ";
    private static final char SEPARATOR = File.separatorChar;

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(READ_FILE_PREFIX)) {
            return null;
        }
        if (c.startsWith(READ_FILE_PREFIX)) {
            String name = c.substring(READ_FILE_PREFIX.length()).trim();
            return new ReadFileCommand(name);
        }
        return null;
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (commandPrefix != null && !READ_FILE_PREFIX.startsWith(prefix = commandPrefix.trim())) {
            return false;
        }
        System.out.println("Read a profiling file and use it for further analysis");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  read file <name>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <name>                 The name of the profiling file to use.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (READ_FILE_PREFIX.startsWith(commandPrefix) && READ_FILE_PREFIX.length() > commandPrefix.length()) {
            commands.add(READ_FILE_PREFIX);
        }
        if (commandPrefix.startsWith(READ_FILE_PREFIX)) {
            File[] files;
            String file = commandPrefix.substring(READ_FILE_PREFIX.length());
            int separatorIndex = file.lastIndexOf(SEPARATOR);
            String filePrefix = separatorIndex < 0 ? file : file.substring(separatorIndex + 1);
            String dir = separatorIndex < 0 ? "." : file.substring(0, separatorIndex + 1);
            boolean prependDir = separatorIndex >= 0;
            File directory = new File(dir);
            if (directory.exists() && (files = directory.listFiles()) != null) {
                for (File f : files) {
                    if (!f.getName().startsWith(filePrefix) || !f.getName().endsWith(".prf") && !f.isDirectory()) continue;
                    commands.add(READ_FILE_PREFIX + (prependDir ? dir : "") + f.getName() + (f.isDirectory() ? Character.valueOf(SEPARATOR) : ""));
                }
            }
        }
    }
}

