/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TimeSeriesResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTimeSeriesModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.AreaVisibilityCommandFactory;
import java.util.ArrayList;

public final class RemoveAreaCommand
implements ReportCommand {
    private final String area;

    public RemoveAreaCommand(String area) {
        this.area = area;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (!(input instanceof TimeSeriesResourceController)) {
            throw new JvmProfReportException("Unsupported controller type for adding columns: " + input.getClass().getName());
        }
        TimeSeriesResourceController controller = (TimeSeriesResourceController)input;
        TypedTimeSeriesModel model = (TypedTimeSeriesModel)controller.getModel();
        boolean known = false;
        for (String v : model.getTags()) {
            if (!v.equals(this.area)) continue;
            known = true;
            break;
        }
        if (!known) {
            System.err.println("Unknown area: " + this.area);
            AreaVisibilityCommandFactory.printPossibleAreas(model);
            throw new JvmProfReportException("");
        }
        ArrayList<String> newSet = new ArrayList<String>();
        for (String v : model.getVisibilitySet()) {
            if (v.equals(this.area)) continue;
            newSet.add(v);
        }
        if (newSet.size() == model.getVisibilitySet().length && context.isInteractive()) {
            System.out.println("Areas '" + this.area + "' was already removed.");
            return context;
        }
        model.setVisibility(newSet.toArray(new String[newSet.size()]));
        if (context.isInteractive()) {
            System.out.println("Removed area '" + this.area + "'.");
        }
        return context;
    }
}

