/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.ColumnResourceController;
import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.presentation.typed.ColumnBasedModel;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.ColumnVisibilityCommandFactory;

public final class RemoveColumnCommand
implements ReportCommand {
    private final String column;

    public RemoveColumnCommand(String column) {
        this.column = column;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        ColumnBasedModel model;
        ColumnResourceController<TypedTableModel> controller;
        Object input = context.getController();
        if (input instanceof TableResourceController) {
            controller = (TableResourceController)input;
            model = (ColumnBasedModel)controller.getModel();
        } else if (input instanceof TreeResourceController) {
            controller = (TreeResourceController)input;
            model = (ColumnBasedModel)controller.getModel();
        } else if (input instanceof ValueSetResourceController) {
            controller = (ValueSetResourceController)input;
            model = (ColumnBasedModel)controller.getModel();
        } else {
            throw new JvmProfReportException("Unsupported controller type for adding columns: " + input.getClass().getName());
        }
        String columnId = ColumnVisibilityCommandFactory.getColumnId(model.getSpec(), this.column);
        if (columnId == null) {
            System.err.println("Unknown column: " + this.column);
            ColumnVisibilityCommandFactory.printPossibleColumns(model.getSpec());
            throw new JvmProfReportException("");
        }
        String columnVisibility = model.getColumnVisibility();
        StringBuilder buffer = new StringBuilder();
        for (String set : columnVisibility.split("[|]")) {
            if (set.equals(columnId)) continue;
            if (buffer.length() > 0) {
                buffer.append('|');
            }
            buffer.append(set);
        }
        model.setColumnVisibility(buffer.toString());
        if (context.isInteractive()) {
            System.out.println("Removed column '" + this.column + "'.");
        }
        return context;
    }
}

