/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;

public final class RemoveNonDefaultColumnsCommand
implements ReportCommand {
    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TableResourceController) {
            TableResourceController controller = (TableResourceController)input;
            TypedTableModel model = (TypedTableModel)controller.getModel();
            model.setColumnVisibility(model.getSpec().getDefaultVisibleSets());
        } else if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            model.setColumnVisibility(model.getSpec().getDefaultVisibleSets());
        } else if (input instanceof ValueSetResourceController) {
            ValueSetResourceController controller = (ValueSetResourceController)input;
            TypedValueSetModel model = (TypedValueSetModel)controller.getModel();
            model.setColumnVisibility(model.getSpec().getDefaultVisibleSets());
        } else {
            throw new JvmProfReportException("Unsupported controller type for adding columns: " + input.getClass().getName());
        }
        if (context.isInteractive()) {
            System.out.println("Removed all non-default columns.");
        }
        return context;
    }
}

