/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import java.io.File;
import java.io.IOException;

public final class SaveCommand
implements ReportCommand {
    private final String file;

    public SaveCommand(String file) {
        this.file = file;
    }

    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        if (new File(this.file).exists()) {
            throw new JvmProfReportException("File \"" + this.file + "\" already exists.");
        }
        try {
            if (context.isInteractive()) {
                System.out.print("Saving profiling data to file '" + this.file + "'... ");
            }
            ProgressReporter reporter = new ProgressReporter();
            context.getFileController().getModelController().write(this.file, reporter);
            reporter.finish();
            if (context.isInteractive()) {
                System.out.println("finished.");
            }
            return context;
        }
        catch (IOException e) {
            if (context.isInteractive()) {
                System.out.println("failed.");
            }
            throw new JvmProfReportException("Error while saving data: " + e.getMessage());
        }
    }
}

