/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportCommandFactory;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.tools.report.command.SaveCommand;
import java.util.List;

public final class SaveCommandFactory
implements ReportCommandFactory {
    private static final String SAVE_PREFIX = "save as ";

    @Override
    public ReportCommand create(String command) {
        String c = command.trim();
        if (!c.startsWith(SAVE_PREFIX)) {
            return null;
        }
        String file = c.substring(SAVE_PREFIX.length()).trim();
        return new SaveCommand(file);
    }

    @Override
    public boolean printUsage(String commandPrefix) {
        String prefix;
        if (!(commandPrefix == null || (prefix = commandPrefix.trim()).length() < SAVE_PREFIX.length() && SAVE_PREFIX.startsWith(prefix) || prefix.length() >= SAVE_PREFIX.length() && prefix.startsWith(SAVE_PREFIX))) {
            return false;
        }
        System.out.println("Saves the current profiling session to a snapshot file");
        System.out.println();
        System.out.println("Usage:");
        System.out.println("  save as <file>");
        System.out.println();
        System.out.println("Definitions:");
        System.out.println("  <file>                 The name of the snapshot file to create.");
        System.out.println();
        return true;
    }

    @Override
    public void getCommandProposals(String commandPrefix, List<String> commands, ReportExecutionContext executionContext) {
        if (SAVE_PREFIX.startsWith(commandPrefix)) {
            commands.add(SAVE_PREFIX);
        }
    }
}

