/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.tools.report.command;

import com.sap.jvm.profiling.controller.TableResourceController;
import com.sap.jvm.profiling.controller.TreeResourceController;
import com.sap.jvm.profiling.controller.ValueSetResourceController;
import com.sap.jvm.profiling.presentation.typed.TypedTableModel;
import com.sap.jvm.profiling.presentation.typed.TypedTreeModel;
import com.sap.jvm.profiling.presentation.typed.TypedValueSetModel;
import com.sap.jvm.profiling.tools.report.JvmProfReportException;
import com.sap.jvm.profiling.tools.report.ReportCommand;
import com.sap.jvm.profiling.tools.report.ReportExecutionContext;
import com.sap.jvm.profiling.viewer.tree.TreeModelForwardIterator;
import com.sap.jvm.profiling.viewer.tree.TreeModelItem;
import java.util.ArrayList;

public final class SelectAllCommand
implements ReportCommand {
    @Override
    public ReportExecutionContext execute(ReportExecutionContext context) throws JvmProfReportException {
        Object input = context.getController();
        if (input instanceof TableResourceController) {
            TableResourceController controller = (TableResourceController)input;
            TypedTableModel model = (TypedTableModel)controller.getModel();
            int[] itemIds = new int[model.getNrOfItems()];
            for (int i = 0; i < itemIds.length; ++i) {
                itemIds[i] = model.getItemId(i);
            }
            model.setSelection(itemIds);
            if (context.isInteractive()) {
                System.out.println("Selected all " + model.getNrOfItems() + " table entries.");
            }
            return context;
        }
        if (input instanceof TreeResourceController) {
            TreeResourceController controller = (TreeResourceController)input;
            TypedTreeModel model = (TypedTreeModel)controller.getModel();
            TreeModelForwardIterator it = new TreeModelForwardIterator(model);
            ArrayList<TreeModelItem> items = new ArrayList<TreeModelItem>();
            while (it.hasNext()) {
                items.add(it.next());
            }
            model.setSelection(items.toArray(new TreeModelItem[items.size()]));
            if (context.isInteractive()) {
                System.out.println("Selected all " + items.size() + " visible tree entries.");
            }
            return context;
        }
        if (input instanceof ValueSetResourceController) {
            ValueSetResourceController controller = (ValueSetResourceController)input;
            TypedValueSetModel model = (TypedValueSetModel)controller.getModel();
            int[] itemIds = new int[model.getNrOfRows()];
            for (int i = 0; i < itemIds.length; ++i) {
                itemIds[i] = i;
            }
            model.setSelectedRows(itemIds);
            if (context.isInteractive()) {
                System.out.println("Selected all " + model.getNrOfRows() + " rows.");
            }
            return context;
        }
        throw new JvmProfReportException("Unsupported controller type for selecting all entries: " + input.getClass().getName());
    }
}

